% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/b2GetFileInfo.R
\name{b2GetFileInfo}
\alias{b2GetFileInfo}
\title{B2 Get File Info.}
\usage{
b2GetFileInfo(fileId)
}
\arguments{
\item{fileId}{The unique identifier of the file whose information is
required. File IDs may be obtained through the \code{b2ListFiles},
\code{b2ListFileVersions} and \code{b2UploadFile} functions in this
package.}
}
\value{
If successful a list will be returned containing \code{fileId},
  \code{fileName}, \code{accountId}, \code{contentSha1}, \code{bucketId},
  \code{contentLength}, \code{contentType} and \code{fileInfo}.
}
\description{
\code{b2GetFileInfo} returns information about a single file from the user's
account on the Backblaze B2 cloud storage product.
}
\details{
This function returns information about a single file from the user's account
on the Backblaze B2 cloud storage product. Further details regarding this API
call are available here:

\url{https://www.backblaze.com/b2/docs/b2_get_file_info.html}

\code{fileId} is mandatory and must be user defined.
}
\examples{
\dontrun{
b2GetFileInfo(fileId = "Unique_identifier_of_the_file")
}

}

