% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PackageData.R
\docType{data}
\name{GermanCounties}
\alias{GermanCounties}
\title{List of German administrative counties}
\format{
A \code{\link[data.table]{data.table}} with 401 rows and 3 variables:
\describe{
  \item{\code{stateId}}{id of state containing this county.}
  \item{\code{countyId}}{unique id, first five digits of the German AGS.}
  \item{\code{county}}{name of county in German.}
}
}
\source{
Gemeindeverzeichnis-Informationssystem (GV-ISys) of the German Federal Statistics Office
}
\usage{
GermanCounties
}
\description{
A dataset containing the names and AGS of all 401 German counties.
}
\examples{
x <- merge(GermanCounties, GermanStates, by="stateId")
subset(x, countyId == "05135") # Cologne, North Rhine-Westphalia

}
\seealso{
\code{\link{GermanStates}} for German states.
}
\keyword{datasets}
