% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_describe_reserved_instances_modifications}
\alias{ec2_describe_reserved_instances_modifications}
\title{Describe Reserved Instances Modifications}
\usage{
ec2_describe_reserved_instances_modifications(
  Filter = NULL,
  ReservedInstancesModificationId = NULL,
  NextToken = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{Filter}{Named list where the name is the filter name and the value is the
filter's value. The value can be a vector or a list object (see below)[optional]}

\item{ReservedInstancesModificationId}{List. IDs for the submitted modification request.[optional]}

\item{NextToken}{Characters. The token for the next page of results[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Describe Reserved Instances Modifications
}
\section{Filter}{


One or more filters.
\itemize{
\item \code{client-token} - The idempotency token for the modification request.
\item \code{create-date} - The time when the modification request was created.
\item \code{effective-date} - The time when the modification becomes effective.
\item \code{modification-result.reserved-instances-id} - The ID for the
Reserved Instances created as part of the modification request. This
ID is only available when the status of the modification is
\code{fulfilled}.
\item \code{modification-result.target-configuration.availability-zone} - The
Availability Zone for the new Reserved Instances.
\item \code{modification-result.target-configuration.instance-count } - The
number of new Reserved Instances.
\item \code{modification-result.target-configuration.instance-type} - The
instance type of the new Reserved Instances.
\item \code{modification-result.target-configuration.platform} - The network
platform of the new Reserved Instances (\code{EC2-Classic} \| \code{EC2-VPC}).
\item \code{reserved-instances-id} - The ID of the Reserved Instances modified.
\item \code{reserved-instances-modification-id} - The ID of the modification
request.
\item \code{status} - The status of the Reserved Instances modification request
(\code{processing} \| \code{fulfilled} \| \code{failed}).
\item \code{status-message} - The reason for the status.
\item \code{update-date} - The time when the modification request was last
updated.
}
}

\section{ReservedInstancesModificationId}{

IDs for the submitted modification
request.
}

