% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_describe_vpc_peering_connections}
\alias{ec2_describe_vpc_peering_connections}
\title{Describe Vpc Peering Connections}
\usage{
ec2_describe_vpc_peering_connections(
  Filter = NULL,
  DryRun = NULL,
  VpcPeeringConnectionId = NULL,
  NextToken = NULL,
  MaxResults = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{Filter}{Named list where the name is the filter name and the value is the
filter's value. The value can be a vector or a list object (see below)[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{VpcPeeringConnectionId}{List.   One or more VPC peering connection IDs.  Default: Describes all your VPC peering connections.  [optional]}

\item{NextToken}{Characters, The token for the next page of results[optional]}

\item{MaxResults}{Integer. The maximum number of results to return with a single call.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Describes one or more of your VPC peering
connections.
}
\section{Filter}{


One or more filters.
\itemize{
\item \code{accepter-vpc-info.cidr-block} - The IPv4 CIDR block of the accepter
VPC.
\item \code{accepter-vpc-info.owner-id} - The AWS account ID of the owner of
the accepter VPC.
\item \code{accepter-vpc-info.vpc-id} - The ID of the accepter VPC.
\item \code{expiration-time} - The expiration date and time for the VPC peering
connection.
\item \code{requester-vpc-info.cidr-block} - The IPv4 CIDR block of the
requester\'s VPC.
\item \code{requester-vpc-info.owner-id} - The AWS account ID of the owner of
the requester VPC.
\item \code{requester-vpc-info.vpc-id} - The ID of the requester VPC.
\item \code{status-code} - The status of the VPC peering connection
(\code{pending-acceptance} \| \code{failed} \| \code{expired} \| \code{provisioning} \|
\code{active} \| \code{deleting} \| \code{deleted} \| \code{rejected}).
\item \code{status-message} - A message that provides more information about
the status of the VPC peering connection, if applicable.
\item \code{tag}:\ - The key/value combination of a tag assigned to the
resource. Use the tag key in the filter name and the tag value as
the filter value. For example, to find all resources that have a tag
with the key \code{Owner} and the value \code{TeamA}, specify \code{tag:Owner} for
the filter name and \code{TeamA} for the filter value.
\item \code{tag-key} - The key of a tag assigned to the resource. Use this
filter to find all resources assigned a tag with a specific key,
regardless of the tag value.
\item \code{vpc-peering-connection-id} - The ID of the VPC peering connection.
}
}

\section{DryRun}{

Checks whether you have the required permissions
for the action, without actually making the request, and provides an
error response. If you have the required permissions, the error response
is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{VpcPeeringConnectionId}{


One or more VPC peering connection IDs.

Default: Describes all your VPC peering connections.
}

\section{MaxResults}{

The maximum number of results to return
with a single call. To retrieve the remaining results, make another call
with the returned \code{nextToken} value.
}

