% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_delete_security_group}
\alias{ec2_delete_security_group}
\title{Delete Security Group}
\usage{
ec2_delete_security_group(
  GroupId = NULL,
  GroupName = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{GroupId}{String. The ID of the security group. Required for a nondefault VPC.[optional]}

\item{GroupName}{String. [EC2-Classic, default VPC] The name of the security group.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Delete Security Group
}
\section{GroupId}{

The ID of the security
group. Required for a nondefault VPC.
}

\section{GroupName}{

[EC2-Classic,
default VPC] The name of the security group. You can specify either the
security group name or the security group ID.
}

\section{DryRun}{

Checks
whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.
}

