% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_delete_placement_group}
\alias{ec2_delete_placement_group}
\title{Delete Placement Group}
\usage{
ec2_delete_placement_group(
  GroupName,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{GroupName}{String. The name of the placement group.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Deletes the specified placement
group. You must terminate all instances in the placement group before
you can delete the placement group. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html}{Placement groups}
in the \emph{Amazon EC2 User Guide}.
}
\section{GroupName}{

The name of the placement
group.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

