% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_create_snapshot}
\alias{ec2_create_snapshot}
\title{Create Snapshot}
\usage{
ec2_create_snapshot(
  VolumeId,
  Description = NULL,
  OutpostArn = NULL,
  TagSpecification = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{VolumeId}{String. The ID of the EBS volume.}

\item{Description}{String. A description for the snapshot.[optional]}

\item{OutpostArn}{String.   The Amazon Resource Name (ARN) of the AWS Outpost on which to create a local snapshot.[optional]}

\item{TagSpecification}{List. The tags to apply to the snapshot during creation.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Create Snapshot
}
\section{VolumeId}{

The ID of the EBS
volume.
}

\section{Description}{

A description for the
snapshot.
}

\section{OutpostArn}{


The Amazon Resource Name (ARN) of the AWS Outpost on which to create a
local snapshot.
\itemize{
\item To create a snapshot of a volume in a Region, omit this parameter.
The snapshot is created in the same Region as the volume.
\item To create a snapshot of a volume on an Outpost and store the
snapshot in the Region, omit this parameter. The snapshot is created
in the Region for the Outpost.
\item To create a snapshot of a volume on an Outpost and store the
snapshot on an Outpost, specify the ARN of the destination Outpost.
The snapshot must be created on the same Outpost as the volume.
}

For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#create-snapshot}{Creating local snapshots from volumes on an Outpost}
in the \emph{Amazon Elastic Compute Cloud User Guide}.
}

\section{TagSpecification}{

The tags to apply to the snapshot during
creation.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

