% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_apply_security_groups_to_client_vpn_target_network}
\alias{ec2_apply_security_groups_to_client_vpn_target_network}
\title{Apply Security Groups To Client Vpn Target Network}
\usage{
ec2_apply_security_groups_to_client_vpn_target_network(
  ClientVpnEndpointId,
  VpcId,
  SecurityGroupId,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{ClientVpnEndpointId}{String. The ID of the Client VPN endpoint.}

\item{VpcId}{String. The ID of the VPC in which the associated target network is located.}

\item{SecurityGroupId}{List. The IDs of the security groups to apply to the associated target network.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Applies a security group to the
association between the target network and the Client VPN endpoint. This
action replaces the existing security groups with the specified security
groups.
}
\section{ClientVpnEndpointId}{

The ID of the Client VPN
endpoint.
}

\section{VpcId}{

The ID of the VPC in which the associated
target network is located.
}

\section{SecurityGroupId}{

The IDs of the security
groups to apply to the associated target network. Up to 5 security
groups can be applied to an associated target
network.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

