% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_transcriptome.R
\name{plot_transcriptome}
\alias{plot_transcriptome}
\title{Get a plot of the transcriptome as a chord diagram}
\usage{
plot_transcriptome(
  transcriptome_id,
  seed_id = NULL,
  save = FALSE,
  file_name = NULL,
  save_path = "~/transcriptome@chords",
  format = "svg",
  silent = FALSE
)
}
\arguments{
\item{transcriptome_id}{Integer}

\item{seed_id}{Integer (from 1 to 1000), a vector of integer values, or a
logical value. This integer is used for starting the pseudo-random number
generator that represents the environment experiencing a digital organism.
If a logical value is used, TRUE returns data found in all environments and
FALSE (by default) returns only distinct data regardless of the seed.}

\item{save}{Logical value (TRUE/FALSE) to save the plot (FALSE by default).}

\item{file_name}{String of characters indicating the name of the file to be
saved (without extension).}

\item{save_path}{String of characters indicating the name of the folder where
the file will be saved.}

\item{format}{String of characters indicating the format of the file ("pdf"
and "svg" are currently supported).}

\item{silent}{Logical value (TRUE/FALSE) to show/hide messages (TRUE by
default).}
}
\description{
Get a plot of the transcriptome executed by a digital organism
for a list of seeds used for starting the pseudo-random number generator
(i.e., a set of environments).
}
\examples{
\dontrun{
# plot transcriptome 53674 at seed_1 and save to disk in pdf format
plot_transcriptome(
  transcriptome_id = 53674,
  seed_id = 1,
  save = TRUE,
  save_path = getwd(),
  format = "pdf"
)
}
}
