% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_mutant_at_pos.R
\name{get_mutant_at_pos}
\alias{get_mutant_at_pos}
\title{Get a single-point mutant of a digital organism}
\usage{
get_mutant_at_pos(inst_replaced, inst_replaced_by, pos)
}
\arguments{
\item{inst_replaced}{A letter representing the instruction of the genome
sequence of the organism to be mutated.}

\item{inst_replaced_by}{A letter representing the instruction replaced in the
genome of the single-point mutant.}

\item{pos}{Integer representing the position of the single-point mutation
along the genome of a digital organism (from 1 to 100 for a genome length of
100 instructions).}
}
\value{
Data frame: Columns: "genome_id_ancestor", "genome_seq_ancestor",
"genome_id_mutant", genome_seq_mutant".
}
\description{
Get the genome sequences of a digital organism and one of its
single-point mutants.
}
\examples{

get_mutant_at_pos(inst_replaced = 'o', inst_replaced_by = 'a', pos = 1)

}
