% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stack_thresh.R
\name{MeanStackThresh}
\alias{MeanStackThresh}
\alias{MedStackThresh}
\title{Threshold every image frame in a stack based on their mean/median.}
\usage{
MeanStackThresh(arr3d, method, fail = NA, skip.consts = FALSE)

MedStackThresh(arr3d, method, fail = NA, skip.consts = FALSE)
}
\arguments{
\item{arr3d}{A 3-dimensional array (the image stack) where the \eqn{n}th
slice is the \eqn{n}th image in the time series.}

\item{method}{The thresholding method to use. See
[autothresholdr::auto_thresh].}

\item{fail}{To which value should pixels not exceeeding the threshold be set?}

\item{skip.consts}{An array with only one value (a 'constant array') won't
threshold properly. By default the function would give an error, but by
setting this parameter to `TRUE`, the array would instead be skipped (the
function will return the original array) and give a warning.}
}
\value{
A 3d array, the thresholded stack. Pillars not exceeding the
  threshold are set to zero. The attribute 'threshold' gives the value used
  for thresholding.
}
\description{
This function finds a threshold based on all of the frames, then takes the
mean/median of all the frames in the stack image, uses this to create a mask
and then applies this mask to every frame in the stack (so for a given pillar
in the image stack, either all the pixels therein are thresholded away, all
are untouched).
}
\examples{
library(EBImage)
img <- imageData(readImage(system.file('extdata', '50.tif',
                                       package = 'autothresholdr'),
                           as.is = TRUE))
display(normalize(img[, , 1]), method = 'raster')
img_thresh_mask <- MeanStackThresh(img, 'Otsu')
display(img_thresh_mask[, , 1] > 0, method = 'r')
display(normalize(img[, , 1]), method = 'raster')
img_thresh_mask <- MedStackThresh(img, 'Triangle')
display(img_thresh_mask[, , 1] > 0, method = 'r')

img_thresh_mask <- MedStackThresh(img, 'Triangle')
display(img_thresh_mask[, , 1] > 0, method = 'r')

}
