% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/populate_soln_env.R
\name{populate_soln_env}
\alias{populate_soln_env}
\title{Returns solution environment and test code from template.}
\usage{
populate_soln_env(soln_fname, pattern, knit_root_dir, render_only = FALSE)
}
\arguments{
\item{soln_fname}{An rmd file containing the unit tests (and others) to be
run on the student solution.}

\item{pattern}{The pattern that identifies which chunks in the solution are 
are test code chunks. This includes testthat chunks and other chunks for 
generating features from student code/objects. If this argument is missing,
the default pattern used is "test"}

\item{knit_root_dir}{The root directory to use for knitting the rmd file. This
argument is optional. If it is missing, it uses the root directory in
knitr::opts_knit$get('root.dir').}

\item{render_only}{A logical value. If this is TRUE, then the solution is
run and rendered. In this case, a list of length two is returned. If this is 
FALSE (default), then then a list of length three is returned. See the
Return section for more details.}
}
\value{
If render_only is FALSE, a list containing 3 components: the
environment populated by the solution rmd, the path to an R script
containing the test code chunks, and a list of test names and expectations.

If render_only is TRUE, then a path to the rendered html file, and the 
solution environment are returned. This latter case is useful for
debugging the solution file.
}
\description{
Generates objects for checking solution correctness.
}
\details{
Test code should be written in two ways:
\enumerate{
\item  As \code{\link[testthat]{test_that}} blocks; the first chunk 
should load the testthat package. There could be more than one test chunk.
\item As chunks with code that generates scalars from students' objects. 
} 
Keep these two types of chunks separate for best results.

The solution file has to be an Rmd file (not an R script), because it 
relies on the autoharp.obj and autoharp.scalars knitr hooks being present.

In addition, if it is required that a solution object is to be tested against
the analogous object within the student environment, these objects should be 
listed within the autoharp option of a code chunk. These objects will be 
copied with the "." preffix.

Here is an overview of how the function works:
\enumerate{
  \item Knit the solution file to generate the solution (or "correct") 
  objects. 
  \item Rename these with the "." prefix in the solution environment
  object.
  \item Extract the lines of test code into a temporary R script.
  \item Wrap those chunks with autoharp.scalars hook with tryCatch.
  \item Add a few lines at the bottom of the script to indicate which
  scalars should be kept.
  \item Return the solution environment, path to the R test script, and
  list of test names and expectations in the solution script.
}

Typically, the next step is to call \code{\link{check_correctness}}.
}
\seealso{
\code{\link{check_correctness}}, \code{\link{render_one}}
}
