% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/highlight2.R
\name{highlight2}
\alias{highlight2}
\title{Highlight a data.frame}
\usage{
highlight2(x, i = NULL, j = NULL, style = NULL, include.colname = FALSE)
}
\arguments{
\item{x}{A data.frame}

\item{i}{numeric rows to highlight}

\item{j}{numeric columns to hightlight}

\item{style}{A style function or NULL}

\item{include.colname}{logical Whether or not include colname}
}
\value{
a data.frame
}
\description{
Highlight a data.frame
}
\examples{
head(mtcars) \%>\% highlight2(i=3) \%>\% printdf()
library(crayon)
head(mtcars) \%>\% highlight2(i=2) \%>\% highlight2(j=3,style=blue$bold) \%>\% printdf()
fit=lm(mpg~wt*hp,data=mtcars)
gaze(fit)
gaze(fit) \%>\% highlight2(j=4,include.colname=TRUE)
gaze(fit) \%>\% highlight2(i=2,j=4) \%>\% highlight2(i=2,j=2:3,style=blue$bold)
gaze(fit) \%>\% highlight2(i=2) \%>\% highlight2(j=3,style=blue$bold)
}
