% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{plot.autoMrP}
\alias{plot.autoMrP}
\title{A plot method for autoMrP objects. Plots unit-level preference estiamtes.}
\usage{
\method{plot}{autoMrP}(x, algorithm = "ebma", ci.lvl = 0.95, ...)
}
\arguments{
\item{x}{An \code{autoMrP()} object.}

\item{algorithm}{The algorithm/classifier fo which preference estimates are
desired. A character-valued scalar indicating either \code{ebma} or the
classifier to be used. Allowed choices are: "ebma", "best_subset", "lasso",
"pca", "gb", "svm", and "mrp". Default is \code{ebma}.}

\item{ci.lvl}{The level of the confidence intervals. A proportion. Default is
\code{0.95}. Confidence intervals are based on bootstrapped estimates and
will not be printed if bootstrapping was not carried out.}

\item{...}{Additional arguments affecting the summary produced.}
}
\value{
Returns a \code{ggplot2} object of the preference estimates for the
selected classifier.
}
\description{
\code{plot.autoMrP()} plots unit-level preference estimates and error bars.
}
