% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotD3_autocorrelation.R
\name{plotD3_autocorrelation}
\alias{plotD3_autocorrelation}
\alias{plotD3Autocorrelation}
\title{Autocorrelation Plot in D3 with r2d3 package.}
\usage{
plotD3_autocorrelation(object, ..., variable = NULL, points = TRUE,
  smooth = FALSE, point_count = NULL, single_plot = TRUE,
  scale_plot = FALSE, background = FALSE)

plotD3Autocorrelation(object, ..., variable = NULL, points = TRUE,
  smooth = FALSE, point_count = NULL, single_plot = TRUE,
  scale_plot = FALSE, background = FALSE)
}
\arguments{
\item{object}{An object of class 'auditor_model_residual' created with \code{\link{model_residual}} function.}

\item{...}{Other 'auditor_model_residual' objects to be plotted together.}

\item{variable}{Name of variable to order residuals on a plot.
If \code{variable="_y_"}, the data is ordered by a vector of actual response (\code{y} parameter
passed to the \code{\link[DALEX]{explain}} function).}

\item{points}{Logical, indicates whenever observations should be added as points. By defaul it's TRUE.}

\item{smooth}{Logical, indicates whenever smoothed lines should be added. By default it's FALSE.}

\item{point_count}{Number of points to be plotted per model. Points will be chosen randomly.
By default plot all of them.}

\item{single_plot}{Logical, indicates whenever single or facets should be plotted. By default it's TRUE.}

\item{scale_plot}{Logical, indicates whenever the plot should scale with height. By default it's FALSE.}

\item{background}{Logical, available only if single_plot = FALSE. Indicates whenever backgroud plots should be plotted.
By default it's FALSE.}
}
\value{
a `r2d3` object.
}
\description{
Plot of i-th residual vs i+1-th residual.
}
\examples{

dragons <- DALEX::dragons[1:100, ]

# fit a model
model_lm <- lm(life_length ~ ., data = dragons)

# use DALEX package to wrap up a model into explainer
exp_lm <- DALEX::explain(model_lm, data = dragons, y = dragons$life_length)

# validate a model with auditor
library(auditor)
mr_lm <- model_residual(exp_lm)

# plot results
plotD3_autocorrelation(mr_lm)
plotD3_autocorrelation(mr_lm, smooth = TRUE)

}
