% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_evaluation.R
\name{model_evaluation}
\alias{model_evaluation}
\alias{modelEvaluation}
\title{Create Model Evaluation Explaination}
\usage{
model_evaluation(object)

modelEvaluation(object)
}
\arguments{
\item{object}{An object of class 'explainer' created with function \code{\link[DALEX]{explain}} from the DALEX package.}
}
\value{
An object of class 'auditor_model_evaluation'.
}
\description{
Creates explanation of classification model.

Returns, among others, true positive rate (tpr), false positive rate (fpr),
rate of positive prediction (rpp), and true positives (tp).

Created object of class 'auditor_model_evaluation' can be used to plot
Receiver Operating Characteristic (ROC) curve (plot \code{\link{plot_roc}}) and LIFT curve (plot \code{\link{plot_lift}}).
}
\examples{
titanic <- na.omit(DALEX::titanic)
titanic$survived <- titanic$survived == "yes"

# fit a model
model_glm <- glm(survived ~ ., family = binomial, data = titanic)

# use DALEX package to wrap up a model into explainer
exp_glm <- DALEX::explain(model_glm, data= titanic, y = titanic$survived)

# validate a model with auditor
library(auditor)
model_evaluation(exp_glm)


}
