% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_entity.R
\name{update_entity}
\alias{update_entity}
\title{Update tags and enabled status of an entity.}
\usage{
update_entity(entity, tag_names = character(0), tag_values = character(0),
  enabled = NA, verbose = FALSE)
}
\arguments{
\item{entity}{Required argument, an entity name. The entity should exist into ATSD.
In case you want to create new entity use the \code{\link{create_entity}} function.}

\item{tag_names}{Optional argument, a character vector of names of tags.}

\item{tag_values}{Optional argument, a character vector of values of tags. 
This vector should has the same length as the \code{tag_names} vector.}

\item{enabled}{Optional boolean argument.
If \code{enabled = TRUE} the entity will be enabled,
if \code{enabled = FALSE} the entity will be disabled,
in the default case \code{enabled = NA} the enabled status of entity will not be changed.}

\item{verbose}{Optional boolean argument, \code{FALSE} by default. 
If \code{verbose = FALSE} then console output will be suppressed.}
}
\value{
code{TRUE} if update success, \code{FALSE} --- otherwise.
}
\description{
Update specified tags and enabled status of an existing entity. Tags
that are not specified are left unchanged.
}
