% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-ref-fishbase.R
\name{get_ref_fishbase}
\alias{get_ref_fishbase}
\title{Extract the bibliographic info from www.fishbase.org.}
\usage{
get_ref_fishbase(growth_fishbase, mirror = "se")
}
\arguments{
\item{growth_fishbase}{Dataframe generated with \link{get_growth_fishbase}.}

\item{mirror}{Character string defining the url mirror to use. Defaults to \code{se}.
In case data extraction is slow use a different mirror. Try to avoid frequently used mirrors
like \code{uk} or \code{com}.}
}
\value{
Dataframe
}
\description{
Extract bibliographic information for growth parameters (linf, k, t0) from www.fishbase.org
}
\examples{
\dontrun{
fish <- c("Gadus morhua", "Merlangius merlangus")
growth_fishbase <- get_growth_fishbase(fish)
get_ref_fishbase(growth_fishbase)

growth_fishbase <- get_growth_fishbase("Scyliorhinus canicula")
df <- get_ref_fishbase(growth_fishbase)
}
}
