/*
 * Decompiled with CFR 0.152.
 */
package asymmetry;

import asymmetry.Cholesky;
import asymmetry.CholeskyException;

public class slidevector {
    double[][] X;
    double[][] BMAT;
    double[][] V;
    double[][] W;
    double[][] Z;
    double[][] ZVZ;
    double[][] VMAT;
    double[][] B;
    double[][] diss;
    int dim;
    int nobj;
    int nobs;
    int maxiter;
    int iter;
    boolean verbose;
    double stress;
    double eps;

    public void makeV() {
        int j;
        int i;
        this.V = new double[this.nobj][this.nobj];
        for (i = 0; i < this.nobs; ++i) {
            for (j = this.nobs; j < this.nobj; ++j) {
                this.V[i][j] = -1.0;
                this.V[j][i] = -1.0;
            }
        }
        for (i = 0; i < this.nobs; ++i) {
            for (j = this.nobs; j < this.nobj; ++j) {
                double[] dArray = this.V[i];
                int n = i;
                dArray[n] = dArray[n] - this.V[i][j];
                double[] dArray2 = this.V[j];
                int n2 = j;
                dArray2[n2] = dArray2[n2] - this.V[i][j];
            }
        }
    }

    public void makeV(double[][] W) {
        int j;
        int i;
        this.V = new double[this.nobj][this.nobj];
        for (i = 0; i < this.nobs; ++i) {
            for (j = this.nobs; j < this.nobj; ++j) {
                this.V[i][j] = -1.0 * W[i][j - this.nobs];
                this.V[j][i] = -1.0 * W[j - this.nobs][i];
            }
        }
        for (i = 0; i < this.nobs; ++i) {
            for (j = this.nobs; j < this.nobj; ++j) {
                double[] dArray = this.V[i];
                int n = i;
                dArray[n] = dArray[n] - this.V[i][j];
                double[] dArray2 = this.V[j];
                int n2 = j;
                dArray2[n2] = dArray2[n2] - this.V[i][j];
            }
        }
    }

    public double[][] slidevectormodel(double[][] d, int ndim, boolean verb, int maxiterations, double epsi) {
        this.nobs = d[0].length;
        this.nobj = 2 * this.nobs;
        this.maxiter = maxiterations;
        this.verbose = verb;
        this.dim = ndim;
        this.eps = epsi;
        this.diss = new double[this.nobj][this.nobj];
        for (int i = 0; i < this.nobs; ++i) {
            for (int j = 0; j < this.nobs; ++j) {
                this.diss[i][j + this.nobs] = d[i][j];
                this.diss[j + this.nobs][i] = this.diss[i][j + this.nobs];
            }
        }
        this.smacof();
        this.info();
        return this.getConfiguration();
    }

    public void smacof() {
        int i;
        int j;
        int i2;
        this.makeV();
        this.Z = new double[this.nobj][this.nobs + 1];
        this.B = new double[this.nobs + 1][this.dim];
        for (i2 = 0; i2 < this.nobs; ++i2) {
            this.Z[i2][i2] = 1.0;
            this.Z[this.nobs + i2][i2] = 1.0;
            this.Z[i2][this.nobs] = 1.0;
        }
        this.ZVZ = new double[this.nobs + 1][this.nobs + 1];
        for (i2 = 0; i2 < this.nobs + 1; ++i2) {
            for (int j2 = 0; j2 < this.nobs + 1; ++j2) {
                for (int k = 0; k < this.nobj; ++k) {
                    for (int l = 0; l < this.nobj; ++l) {
                        double[] dArray = this.ZVZ[i2];
                        int n = j2;
                        dArray[n] = dArray[n] + this.Z[k][i2] * this.V[k][l] * this.Z[l][j2];
                    }
                }
            }
        }
        Cholesky cd = new Cholesky(this.nobs + 1);
        cd.setdouble(this.ZVZ);
        for (int i3 = 0; i3 < this.nobs; ++i3) {
            for (j = i3; j < this.nobs; ++j) {
                cd.addValue(i3, j, 1.0 / (double)this.nobs);
            }
        }
        try {
            cd.toUppertriangle();
        }
        catch (CholeskyException i3) {
            // empty catch block
        }
        cd.invert();
        for (i = 0; i < this.nobs; ++i) {
            for (j = i; j < this.nobs; ++j) {
                cd.addValue(i, j, -1.0 / (double)this.nobs);
            }
        }
        this.VMAT = cd.getdouble();
        this.BMAT = new double[this.nobj][this.nobj];
        this.X = new double[this.nobj][this.dim];
        for (i = 0; i < this.nobj; ++i) {
            for (j = 0; j < this.dim; ++j) {
                this.X[i][j] = Math.random();
            }
        }
        this.BMAT = this.BMAT();
        double[][] XTIL = new double[this.nobj][this.dim];
        for (int i4 = 0; i4 < this.nobj; ++i4) {
            for (int j3 = 0; j3 < this.dim; ++j3) {
                for (int k = 0; k < this.nobj; ++k) {
                    double[] dArray = XTIL[i4];
                    int n = j3;
                    dArray[n] = dArray[n] + this.BMAT[i4][k] * this.X[k][j3];
                }
            }
        }
    }

    public double[][] BMAT() {
        int j;
        int i;
        for (i = 0; i < this.nobj; ++i) {
            for (j = 0; j < this.nobj; ++j) {
                this.BMAT[i][j] = slidevector.distance(this.X, this.dim, i, j) > 1.0E-16 ? this.V[i][j] * this.diss[i][j] / slidevector.distance(this.X, this.dim, i, j) : 0.0;
            }
        }
        for (i = 0; i < this.nobj; ++i) {
            this.BMAT[i][i] = 0.0;
        }
        for (i = 0; i < this.nobj; ++i) {
            for (j = 0; j < this.nobj; ++j) {
                if (i == j) continue;
                double[] dArray = this.BMAT[i];
                int n = i;
                dArray[n] = dArray[n] - this.BMAT[i][j];
            }
        }
        return this.BMAT;
    }

    public double[][] update() {
        double[][] XT = new double[this.nobj][this.dim];
        for (int i = 0; i < this.nobj; ++i) {
            for (int j = 0; j < this.dim; ++j) {
                for (int k = 0; k < this.nobj; ++k) {
                    double[] dArray = XT[i];
                    int n = j;
                    dArray[n] = dArray[n] + this.BMAT[i][k] * this.X[k][j];
                }
            }
        }
        return XT;
    }

    public double[][] weight() {
        int k;
        int j;
        int i;
        double[][] XT = new double[this.nobs + 1][this.dim];
        for (i = 0; i < this.nobs + 1; ++i) {
            for (j = 0; j < this.dim; ++j) {
                this.B[i][j] = 0.0;
            }
        }
        for (i = 0; i < this.nobs + 1; ++i) {
            for (j = 0; j < this.dim; ++j) {
                for (k = 0; k < this.nobj; ++k) {
                    double[] dArray = XT[i];
                    int n = j;
                    dArray[n] = dArray[n] + this.Z[k][i] * this.X[k][j];
                }
            }
        }
        for (i = 0; i < this.nobs + 1; ++i) {
            for (j = 0; j < this.dim; ++j) {
                for (k = 0; k < this.nobs + 1; ++k) {
                    double[] dArray = this.B[i];
                    int n = j;
                    dArray[n] = dArray[n] + this.VMAT[i][k] * XT[k][j];
                }
            }
        }
        for (i = 0; i < this.nobj; ++i) {
            for (j = 0; j < this.dim; ++j) {
                this.X[i][j] = 0.0;
            }
        }
        for (i = 0; i < this.nobj; ++i) {
            for (j = 0; j < this.dim; ++j) {
                for (k = 0; k < this.nobs + 1; ++k) {
                    double[] dArray = this.X[i];
                    int n = j;
                    dArray[n] = dArray[n] + this.Z[i][k] * this.B[k][j];
                }
            }
        }
        return this.X;
    }

    public void info() {
        this.stress = this.stress(this.diss, this.X, this.dim, this.nobj);
        double stressold = this.stress + 10.0;
        while (this.iter < this.maxiter && stressold - this.stress > this.eps) {
            stressold = this.stress;
            this.BMAT = this.BMAT();
            this.X = this.update();
            this.X = this.weight();
            this.stress = this.stress(this.diss, this.X, this.dim, this.nobj);
            if (this.verbose) {
                System.out.println(" stress " + this.stress);
            }
            ++this.iter;
        }
    }

    public double stress(double[][] diss, double[][] X, int dim, int nobj) {
        double stress = 0.0;
        for (int i = 0; i < this.nobs; ++i) {
            for (int j = this.nobs; j < nobj; ++j) {
                stress += Math.pow(diss[i][j] - slidevector.distance(X, dim, i, j), 2.0);
            }
        }
        return stress;
    }

    public double[][] getConfiguration() {
        return this.B;
    }

    public static double distance(double[][] X, int dim, int i, int j) {
        double result = 0.0;
        for (int k = 0; k < dim; ++k) {
            result += Math.pow(X[i][k] - X[j][k], 2.0);
        }
        return Math.sqrt(result);
    }

    public int getDimension() {
        return this.dim;
    }

    public int getNiter() {
        return this.iter;
    }

    public int getNobs() {
        return this.nobs;
    }

    public double getStress() {
        return this.stress;
    }
}

