\name{transactions-class}
\docType{class}
\alias{transactions-class}
%
%\alias{[,transactions-method}
\alias{coerce,matrix,transactions-method}
\alias{coerce,list,transactions-method}
\alias{coerce,transactions,matrix-method}
\alias{coerce,transactions,list-method}
\alias{coerce,data.frame,transactions-method}
\alias{coerce,transactions,data.frame-method}
%\alias{image,transactions-method}
\alias{labels,transactions-method}
\alias{show,transactions-method}
\alias{transactionInfo<-,transactions-method}
\alias{transactionInfo,transactions-method}
\alias{transactionInfo<-}
\alias{transactionInfo}
\alias{t,transactions-method}
%
\alias{summary,transactions-method}
\alias{summary.transactions-class}
\alias{show,summary.transactions-method}

\title{Class ``transactions'' --- Binary Incidence Matrix for
  Transactions}
\description{
  The \code{transactions} class represents transaction data used for
  mining itemsets or rules.  It is a direct extension of class
  \code{\linkS4class{itemMatrix}} to store a binary incidence
  matrix, item labels, and optionally transaction IDs and user IDs.
}
\section{Objects from the Class}{
  Objects are created by coercion from objects of other classes 
  (see Examples section) or by
  calls of the form \code{new("transactions", ...)}.
 }
\section{Slots}{
  \describe{
    \item{\code{transactionInfo}:}{a data.frame
      with vectors of the same length as the number of
      transactions.  Each vector can hold additional information, e.g.,
      store transaction IDs or user IDs for each transaction.}
    \item{\code{data}:}{object of class
      \code{\link[Matrix:ngCMatrix-class]{ngCMatrix}} to store the
      binary incidence matrix (see
      \code{\linkS4class{itemMatrix}} class)} 
    \item{\code{itemInfo}:}{a data.frame to store 
      item labels (see \code{\linkS4class{itemMatrix}} class)}
  }
}
\section{Extends}{
  Class \code{\linkS4class{itemMatrix}}, directly.
}
\section{Methods}{
  \describe{
  %  \item{[}{\code{signature(x = "transactions")};
  %    extracts a subset from the incidence matrix.  The first argument
  %    extracts transactions and the second argument can be used to
  %    extract a subset of items (using item IDs)}
    \item{coerce}{\code{signature(from = "matrix", to = "transactions")};
      produces a transactions data set from a binary incidence matrix. 
      The row names are used as item labels and the column names are
      stores as transaction IDs.
    }
    \item{coerce}{\code{signature(from = "list", to = "transactions")};
      produces a transactions data set from a list.  The names of the
      items in the list are used as item labels and the item IDs and the 
      incidence matrix is produced automatically.
    }
    \item{coerce}{\code{signature(from = "transactions", to = "matrix")}}
    \item{coerce}{\code{signature(from = "transactions", to = "list")}}
    \item{coerce}{\code{signature(from = "data.frame", to = "transactions")}; 
      recodes the data frame containing only categorical variables (all
      have to be factors) into a binary transaction data set.  The needed
      number of dummy items are automatically generated.  The item
      labels are generated by concatenating variable names and levels with
      a \samp{"="}.
      The variable names and levels are stored in the labels data frame
      as the components \code{variables} and \code{levels}.
      Note that \code{NA} in one of the levels is replaced by the string
      \dQuote{NA}, i.e. the special meaning is lost.}
%    \item{image}{\code{signature(x = "transactions")};
%      plots an image of the transactions for visual inspection}
    \item{coerce}{\code{signature(from = "transactions", to = "data.frame")}; 
      represents the set of transactions in a printable form 
      as a data.frame. 
      Note that this does not reverse coercion from data.frame 
      to \code{transactions}.}
    \item{labels}{\code{signature(x = "transactions")};
      returns the labels (item labels and transaction IDs) 
      for the incidence matrix as a list of two vectors named \code{items}
      and \code{transactionID}.}
    \item{transactionInfo<-}{\code{signature(x = "transactions")};
      replaces the transactionInfo data frame}
    \item{transactionInfo}{\code{signature(x = "transactions")};
      returns transactionInfo}
    \item{show}{\code{signature(object = "transactions")}}
    \item{summary}{\code{signature(object = "transactions")}}
  }
}
\seealso{
  \code{\link{[-methods}},
  \code{\link{LIST}},
  \code{\link{WRITE}},
  \code{\link{c}},
  \code{\link{image}},
  \code{\link{inspect}},
  \code{\link{read.transactions}},
  \code{\link{random.transactions}},
  \code{\link{sets}},
  \code{\link{itemMatrix-class}}
}
\examples{
## example 1: creating transactions form a list
a_list <- list(
      c("a","b","c"),
      c("a","b"),
      c("a","b","d"),
      c("c","e"),
      c("a","b","d","e")
      )

## set transaction names
names(a_list) <- paste("Tr",c(1:5), sep = "")
a_list

## coerce into transactions
trans <- as(a_list, "transactions")

## analyze transactions
summary(trans)
image(trans)

## example 2: creating transactions from a matrix
a_matrix <- matrix(
      c(1,1,1,0,0,
	1,1,0,0,0,
	1,1,0,1,0,
	0,0,1,0,1,
	1,1,0,1,1), ncol = 5)

## set dim names
dimnames(a_matrix) <-  list(
	c("a","b","c","d","e"),
	paste("Tr",c(1:5), sep = ""))

a_matrix

## coerce
trans2 <-  as(a_matrix, "transactions")
trans2
inspect(trans2)

## example 3: creating transactions from data.frame
a_df <- data.frame(
	age = as.factor(c(6,8,7,6,9,5)), 
	grade = as.factor(c(1,3,1,1,4,1)))  
## note: all attributes have to be factors
a_df

## coerce
trans3 <- as(a_df, "transactions") 
image(trans3)

## example 4: Creating from data.frame with NA
a_df2 <- sample(c(LETTERS[1:5], NA),10,TRUE)
a_df2 <- data.frame(X = a_df2, Y = sample(a_df2))

a_df2

trans3 <- as(a_df2, "transactions")
trans3
as(trans3, "data.frame")

## example 5: creating transactions from a data.frame with 
## transaction IDs and items 
a_df3 <- data.frame(TID = c(1,1,2,2,2,3), item=c("a","b","a","b","c", "b"))
a_df3
trans4 <- as(split(a_df3[,"item"], a_df3[,"TID"]), "transactions")
trans4
LIST(trans4)
}
\keyword{classes}
