% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/json.R
\name{read_json_arrow}
\alias{read_json_arrow}
\title{Read a JSON file}
\usage{
read_json_arrow(file, col_select = NULL, as_data_frame = TRUE, ...)
}
\arguments{
\item{file}{A character file name or URI, \code{raw} vector, an Arrow input stream,
or a \code{FileSystem} with path (\code{SubTreeFileSystem}).
If a file name, a memory-mapped Arrow \link{InputStream} will be opened and
closed when finished; compression will be detected from the file extension
and handled automatically. If an input stream is provided, it will be left
open.}

\item{col_select}{A character vector of column names to keep, as in the
"select" argument to \code{data.table::fread()}, or a
\link[tidyselect:vars_select]{tidy selection specification}
of columns, as used in \code{dplyr::select()}.}

\item{as_data_frame}{Should the function return a \code{data.frame} (default) or
an Arrow \link{Table}?}

\item{...}{Additional options, passed to \code{json_table_reader()}}
}
\value{
A \code{data.frame}, or an Table if \code{as_data_frame = FALSE}.
}
\description{
Using \link{JsonTableReader}
}
\examples{
\donttest{
  tf <- tempfile()
  on.exit(unlink(tf))
  writeLines('
    { "hello": 3.5, "world": false, "yo": "thing" }
    { "hello": 3.25, "world": null }
    { "hello": 0.0, "world": true, "yo": null }
  ', tf, useBytes=TRUE)
  df <- read_json_arrow(tf)
}
}
