% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csv.R, R/json.R
\name{csv_parse_options}
\alias{csv_parse_options}
\alias{json_parse_options}
\title{Parsing options for Arrow file readers}
\usage{
csv_parse_options(delimiter = ",", quoting = TRUE,
  quote_char = "\\"", double_quote = TRUE, escaping = FALSE,
  escape_char = "\\\\", newlines_in_values = FALSE,
  ignore_empty_lines = TRUE, header_rows = 1L)

json_parse_options(newlines_in_values = FALSE)
}
\arguments{
\item{delimiter}{Field delimiter}

\item{quoting}{Whether quoting is used}

\item{quote_char}{Quoting character (if \code{quoting} is \code{TRUE})}

\item{double_quote}{Whether a quote inside a value is double-quoted}

\item{escaping}{Whether escaping is used}

\item{escape_char}{Escaping character (if \code{escaping} is \code{TRUE})}

\item{newlines_in_values}{Whether values are allowed to contain CR (\code{0x0d}) and LF (\code{0x0a}) characters}

\item{ignore_empty_lines}{Whether empty lines are ignored.  If \code{FALSE}, an empty line represents}

\item{header_rows}{Number of header rows to skip (including the first row containing column names)}
}
\description{
Parsing options for Arrow file readers
}
