context("K-Permutations")

test_that("K-Permutations - npermutations", {
    expect_equal(npermutations(6, 3), 120)
    expect_equal(npermutations(x = LETTERS[1:6], k = 3), 120)
    expect_error(npermutations(14, 10), "integer overflow")
    expect_error(npermutations(x = LETTERS[1:14], k = 10), "integer overflow")
    expect_equal(npermutations(14, 10, bigz = TRUE), gmp::as.bigz("3632428800"))
    expect_equal(npermutations(6, 0), 1)
    expect_equal(npermutations(6, 7), 0)
    expect_error(npermutations(6, -1), "expect non-negative integer")
    expect_error(npermutations(6, 1.5), "expect non-negative integer")

    expect_equal(npermutations(0, 0), 1)
    expect_equal(npermutations(0, 1), 0)
})

test_that("K-Permutations - permutations", {
    perm <- permutations(6, 3)
    expect_equal(nrow(perm), 120)
    expect_equal(ncol(perm), 3)
    expect_equal(perm[1, ], 1:3)
    expect_equal(perm[120, ], 6:4)

    perm <- permutations(6, 3, type = "r")
    expect_equal(nrow(perm), 120)
    expect_equal(ncol(perm), 3)
    expect_equal(perm[1, ], 1:3)
    expect_equal(perm[120, ], 6:4)

    perm <- permutations(6, 3, type = "c")
    expect_equal(ncol(perm), 120)
    expect_equal(nrow(perm), 3)
    expect_equal(perm[, 1], 1:3)
    expect_equal(perm[, 120], 6:4)

    perm <- permutations(6, 3, type = "l")
    expect_equal(length(perm), 120)
    expect_equal(perm[[1]], 1:3)
    expect_equal(perm[[120]], 6:4)

    perm <- permutations(x = LETTERS[1:6], k = 3)
    expect_equal(nrow(perm), 120)
    expect_equal(ncol(perm), 3)
    expect_equal(perm[1, ], LETTERS[1:3])
    expect_equal(perm[120, ], LETTERS[6:4])

    expect_error(permutations(14, 10), "too many results")
    expect_error(permutations(6, -1), "expect non-negative integer")
    expect_error(permutations(6, 1.5), "expect non-negative integer")
    expect_equal(dim(permutations(6, 0)), c(1, 0))
    expect_equal(dim(permutations(6, 7)), c(0, 7))
    expect_equal(dim(permutations(0, 0)), c(1, 0))
    expect_equal(dim(permutations(0, 1)), c(0, 1))
})

test_that("K-Permutations - ipermutations", {
    iperm <- ipermutations(6, 3)
    perm <- permutations(6, 3)
    expect_equal(iperm$collect(), perm)
    expect_equal(iperm$getnext(), 1:3)
    expect_equal(iperm$getnext(), c(1, 2, 4))
    iperm$getnext(110)
    expect_equal(nrow(iperm$getnext(10)), 8)
    expect_equal(iperm$getnext(), NULL)

    perm <- permutations(6, 3, type = "r")
    expect_equal(iperm$collect(), perm)
    expect_equal(iperm$getnext(type = "r"), t(1:3))
    expect_equal(iperm$getnext(type = "r"), t(c(1, 2, 4)))
    iperm$getnext(110, type = "r")
    expect_equal(nrow(iperm$getnext(10)), 8)
    expect_equal(iperm$getnext(type = "r"), NULL)

    perm <- permutations(6, 3, type = "c")
    expect_equal(iperm$collect(type = "c"), perm)
    expect_equal(iperm$getnext(type = "c"), t(t(1:3)))
    expect_equal(iperm$getnext(type = "c"), t(t(c(1, 2, 4))))
    iperm$getnext(110, type = "c")
    expect_equal(ncol(iperm$getnext(10, type = "c")), 8)
    expect_equal(iperm$getnext(type = "c"), NULL)

    perm <- permutations(6, 3, type = "l")
    expect_equal(iperm$collect(type = "l"), perm)
    expect_equal(iperm$getnext(type = "l"), list(1:3))
    expect_equal(iperm$getnext(type = "l"), list(c(1, 2, 4)))
    iperm$getnext(110, type = "l")
    expect_equal(length(iperm$getnext(10, type = "l")), 8)
    expect_equal(iperm$getnext(type = "l"), NULL)

    iperm <- ipermutations(6, 0)
    expect_equal(dim(iperm$collect()), c(1, 0))
    expect_equal(length(iperm$getnext()), 0)
    expect_equal(iperm$getnext(), NULL)
    iperm <- ipermutations(6, 7)
    expect_equal(iperm$collect(), NULL)
    expect_equal(iperm$getnext(), NULL)
    expect_error(ipermutations(6, -1), "expect non-negative integer")
    expect_error(ipermutations(6, 1.5), "expect non-negative integer")
})


context("Multiset K-Permutations")

test_that("Multiset K-Permutations - npermutations", {
    expect_equal(npermutations(freq = c(3, 2, 3), k = 4), 70)
    expect_equal(npermutations(x = LETTERS[1:3], freq = c(3, 2, 3), k = 4), 70)
    expect_error(npermutations(freq = c(10, 50, 10), k = 20), "integer overflow")
    expect_error(npermutations(x = LETTERS[1:3], freq = c(10, 50, 10), k = 20), "integer overflow")
    expect_equal(npermutations(freq = c(10, 50, 10), k = 20, bigz = TRUE), gmp::as.bigz("3224323183"))
    expect_equal(npermutations(freq = c(0, 0, 0), k = 4), 0)
    expect_equal(npermutations(freq = c(0, 0, 0), k = 0), 1)
    expect_error(npermutations(freq = c(3, 2, 3), k = -1), "expect non-negative integer")
    expect_error(npermutations(freq = c(3, 2, 3), k = 1.5), "expect non-negative integer")
})

test_that("Multiset K-Permutations - permutations", {
    perm <- permutations(freq = c(3, 2, 3), k = 4)
    expect_equal(nrow(perm), 70)
    expect_equal(ncol(perm), 4)
    expect_equal(perm[1, ], c(1, 1, 1, 2))
    expect_equal(perm[70, ], c(3, 3, 3, 2))

    perm <- permutations(freq = c(3, 2, 3), k = 4, type = "c")
    expect_equal(ncol(perm), 70)
    expect_equal(nrow(perm), 4)
    expect_equal(perm[, 1], c(1, 1, 1, 2))
    expect_equal(perm[, 70], c(3, 3, 3, 2))

    perm <- permutations(freq = c(3, 2, 3), k = 4, type = "l")
    expect_equal(length(perm), 70)
    expect_equal(perm[[1]], c(1, 1, 1, 2))
    expect_equal(perm[[70]], c(3, 3, 3, 2))

    perm <- permutations(x = LETTERS[1:3], freq = c(3, 2, 3), k = 4)
    expect_equal(nrow(perm), 70)
    expect_equal(ncol(perm), 4)
    expect_equal(perm[1, ], LETTERS[c(1, 1, 1, 2)])
    expect_equal(perm[70, ], LETTERS[c(3, 3, 3, 2)])

    expect_error(permutations(freq = c(10, 50, 10), k = 20), "too many results")
    expect_error(permutations(freq = c(3, 2, 3), k = -1), "expect non-negative integer")
    expect_error(permutations(freq = c(3, 2, 3), k = 1.5), "expect non-negative integer")
    expect_equal(dim(permutations(freq = c(3, 2, 3), k = 0)), c(1, 0))
    expect_equal(dim(permutations(freq = c(0, 0, 0), k = 1 )), c(0, 1))
    expect_equal(dim(permutations(freq = c(0, 0, 0), k = 0 )), c(1, 0))
})

test_that("Multiset K-Permutations - ipermutations", {
    iperm <- ipermutations(freq = c(3, 2, 3), k = 4)
    perm <- permutations(freq = c(3, 2, 3), k = 4)
    expect_equal(iperm$collect(), perm)
    expect_equal(iperm$getnext(), c(1, 1, 1, 2))
    expect_equal(iperm$getnext(), c(1, 1, 1, 3))
    iperm$getnext(60)
    expect_equal(nrow(iperm$getnext(10)), 8)
    expect_equal(iperm$getnext(), NULL)

    perm <- permutations(freq = c(3, 2, 3), k = 4, type = "r")
    expect_equal(iperm$collect(), perm)
    expect_equal(iperm$getnext(type = "r"), t(c(1, 1, 1, 2)))
    expect_equal(iperm$getnext(type = "r"), t(c(1, 1, 1, 3)))
    iperm$getnext(60, type = "r")
    expect_equal(nrow(iperm$getnext(10, type = "r")), 8)
    expect_equal(iperm$getnext(type = "r"), NULL)

    perm <- permutations(freq = c(3, 2, 3), k = 4, type = "c")
    expect_equal(iperm$collect(type = "c"), perm)
    expect_equal(iperm$getnext(type = "c"), t(t(c(1, 1, 1, 2))))
    expect_equal(iperm$getnext(type = "c"), t(t(c(1, 1, 1, 3))))
    iperm$getnext(60, type = "c")
    expect_equal(ncol(iperm$getnext(10, type = "c")), 8)
    expect_equal(iperm$getnext(type = "c"), NULL)

    perm <- permutations(freq = c(3, 2, 3), k = 4, type = "l")
    expect_equal(iperm$collect(type = "l"), perm)
    expect_equal(iperm$getnext(type = "l"), list(c(1, 1, 1, 2)))
    expect_equal(iperm$getnext(type = "l"), list(c(1, 1, 1, 3)))
    iperm$getnext(60, type = "l")
    expect_equal(length(iperm$getnext(10, type = "l")), 8)
    expect_equal(iperm$getnext(type = "l"), NULL)

    expect_error(ipermutations(freq = c(3, 2, 3), k = -1), "expect non-negative integer")
    expect_error(ipermutations(freq = c(3, 2, 3), k = 1.5), "expect non-negative integer")
    iperm <- ipermutations(freq = c(3, 2, 3), k = 0)
    expect_equal(dim(iperm$collect()), c(1, 0))
    expect_equal(length(iperm$getnext()), 0)
    expect_equal(iperm$getnext(), NULL)
    iperm <- ipermutations(freq = c(3, 2, 3), k = 9)
    expect_equal(iperm$collect(), NULL)
    expect_equal(iperm$getnext(), NULL)
})
