% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predicates.R
\name{predicate-numeric}
\alias{predicate-numeric}
\alias{is_odd}
\alias{is_even}
\alias{is_positive}
\alias{is_whole}
\alias{is_binary}
\title{Numeric Predicates}
\usage{
is_odd(x)

is_even(x)

is_positive(x, strict = FALSE)

is_whole(x, tolerance = .Machine$double.eps^0.5)

is_binary(x)
}
\arguments{
\item{x}{A \code{\link{numeric}} object to be tested.}

\item{strict}{A \code{\link{logical}} scalar: should missing values
(including \code{NaN}) be omitted?}

\item{tolerance}{A \code{\link{numeric}} scalar giving the
tolerance to check within.}
}
\value{
A \code{\link{logical}} vector.
}
\description{
Check numeric objects:
}
\details{
\code{is_odd} and \code{is_even} check if a number is odd or even,
respectively.

\code{is_positive} checks if an object contains only (strictly) positive
numbers.

\code{is_binary} checks if an object contains only \eqn{0}s and \eqn{1}s.

\code{is_whole} checks if an object only contains whole numbers.
}
\seealso{
Other predicates: \code{\link{predicate-graph}},
  \code{\link{predicate-matrix}},
  \code{\link{predicate-scalar}},
  \code{\link{predicate-trend}},
  \code{\link{predicate-type}},
  \code{\link{predicate-utils}}
}
\concept{predicates}
\keyword{internal}
