% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_raster.R
\name{match_raster_colors}
\alias{match_raster_colors}
\title{Match colors in RasterLayer color space to the provided legend values}
\usage{
match_raster_colors(legend, x)
}
\arguments{
\item{legend}{An object of class raster_legend as returned by
\code{\link{get_layer_legend}}}

\item{x}{A RasterLayer object as returned by \code{\link{get_map_layer}}}
}
\value{
A raster_legend object with corrected colors to match those in
\code{x}
}
\description{
Colors provided by the legend do not always correspond exactly with the
colors in the colortable of a RasterLayer object. They are usually pretty
close, though, so this function finds the closest colors, maps them to the
appropriate colors in the Raster* object, and applies that to the legend.
}
\details{
Raster colors in \code{x} are mapped to those in \code{legend} by converting
the RGB hexadecimal values to a 3D vector of values for red, green and blue.
The closest values are then assigned using 3D Pythagorean theorem to compute
the distance among all colors. The minimum distance in three dimensional
space is the color in \code{x} that gets mapped to the appropriate color in
\code{legend}.
}
\examples{
\dontrun{
wi_landcover <- get_map_layer(wi_landcover_url, wis_poly)
legend <- get_layer_legend(wi_landcover_url)
new_legend <- match_raster_colors(legend, wi_landcover_url)
}
}
