% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/cloneGithubRepo.R
\name{cloneGithubRepo}
\alias{cloneGithubRepo}
\title{Clone Github Repository}
\usage{
cloneGithubRepo(repoURL, local_path = NULL, ...)
}
\arguments{
\item{repoURL}{The remote repository to clone.}

\item{local_path}{Local directory to clone to. If \code{NULL}, by default, creates a local directory
which corresponds to the name after last \code{/} in \code{repoURL}.}

\item{...}{Further parameters passed to \link[git2r]{clone}.}
}
\description{
\code{cloneGithubRepo} is a wrapper around \code{git clone} and clones GitHub Repository
into the \code{local_path} directory.

More archivist functionalities that integrate archivist and GitHub API can be found here \link{archivist-github-integration} (\link{agithub}).
}
\examples{
\dontrun{

cloneGithubRepo("https://github.com/MarcinKosinski/Museum")
cloneGithubRepo("https://github.com/MarcinKosinski/Museum-Extra")


# empty Github Repository creation

library(httr)
myapp <- oauth_app("github",
                   key = '1fab1e77d27079c0717d',
                   secret = 'c1284ed206b4a7f5f0bca508a6df5919e7fbf799')
github_token <- oauth2.0_token(oauth_endpoints("github"),
                               myapp,
                               scope = "public_repo")
# setting options
aoptions("github_token", github_token)
aoptions("user.name", 'MarcinKosinski')
aoptions("user.password", 'sobieskiego77')

createEmptyGithubRepo("archive-test4")
setGithubRepo(aoptions("user.name"), "archive-test4")
## artifact's archiving
przyklad <- 1:100

# archiving
archive(przyklad) -> md5hash_path

## proof that artifact is really archived
showGithubRepo() # uses options from setGithubRepo
# let's remove przyklad
rm(przyklad)
# and load it back from md5hash_path
aread(md5hash_path)


# clone example
unlink("archive-test", recursive = TRUE)
cloneGithubRepo('https://github.com/MarcinKosinski/archive-test')
setGithubRepo(aoptions("user.name"), "archive-test")
data(iris)
archive(iris)
showGithubRepo()


}
}
\author{
Marcin Kosinski, \email{m.p.kosinski@gmail.com}
}
\seealso{
Other archivist: \code{\link{Repository}};
  \code{\link{Tags}}; \code{\link{\%a\%}};
  \code{\link{addTagsRepo}}; \code{\link{agithub}},
  \code{\link{archivist-github-integration}};
  \code{\link{ahistory}}; \code{\link{aoptions}};
  \code{\link{archive}}; \code{\link{archivist-package}};
  \code{\link{aread}}; \code{\link{asearch}};
  \code{\link{cache}}; \code{\link{copyGithubRepo}},
  \code{\link{copyLocalRepo}};
  \code{\link{createEmptyGithubRepo}},
  \code{\link{createEmptyLocalRepo}},
  \code{\link{createEmptyRepo}}; \code{\link{deleteRepo}};
  \code{\link{getTagsGithub}}, \code{\link{getTagsLocal}};
  \code{\link{loadFromGithubRepo}},
  \code{\link{loadFromLocalRepo}}; \code{\link{md5hash}};
  \code{\link{multiSearchInGithubRepo}},
  \code{\link{multiSearchInLocalRepo}},
  \code{\link{searchInGithubRepo}},
  \code{\link{searchInLocalRepo}};
  \code{\link{rmFromRepo}}; \code{\link{saveToRepo}};
  \code{\link{setGithubRepo}}, \code{\link{setLocalRepo}};
  \code{\link{shinySearchInLocalRepo}};
  \code{\link{showGithubRepo}},
  \code{\link{showLocalRepo}};
  \code{\link{splitTagsGithub}},
  \code{\link{splitTagsLocal}};
  \code{\link{summaryGithubRepo}},
  \code{\link{summaryLocalRepo}};
  \code{\link{zipGithubRepo}}, \code{\link{zipLocalRepo}}
}

