% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attachments.R
\name{query_layer_attachments}
\alias{query_layer_attachments}
\alias{download_attachments}
\title{Query and download attachments}
\usage{
query_layer_attachments(
  x,
  definition_expression = "1=1",
  attachments_definition_expression = NULL,
  object_ids = NULL,
  global_ids = NULL,
  attachment_types = NULL,
  keywords = NULL,
  ...,
  token = arc_token()
)

download_attachments(
  attachments,
  out_dir,
  ...,
  overwrite = FALSE,
  .progress = TRUE,
  token = arc_token()
)
}
\arguments{
\item{x}{an object of class \code{FeatureLayer}, \code{Table}, or \code{ImageServer}.}

\item{definition_expression}{default \code{1 = 1}. A SQL where clause that is applied to the layer. Only those records that conform to this expression will be returned. This parameter is required if neither \code{object_ids} or \code{global_ids} have been defined.}

\item{attachments_definition_expression}{default \code{NULL}. A SQL where calsue that is applied to the attachment metadata.
only attachments that conform to this expression will be returned.}

\item{object_ids}{mutually exclusive with \code{definition_expression} and \code{global_ids}. The object IDs of the features to query attachments of.}

\item{global_ids}{mutally exclusive with \code{definition_expression} and \code{object_ids}. The global IDs of the features to query attachments of.}

\item{attachment_types}{default \code{NULL}. A character vector of attachment types to filter on.}

\item{keywords}{default \code{NULL}. A character vector of the keywords to filter on.}

\item{...}{unused}

\item{token}{your authorization token.}

\item{attachments}{a \code{data.frame} created by \code{query_layer_attachments()}. Must contain the columns \code{name}, \code{url}, and \code{contentType}.}

\item{out_dir}{the path to the folder to download the file}

\item{overwrite}{default \code{FALSE}. A}

\item{.progress}{default \code{TRUE.} Whether a progress bar should be provided.}
}
\value{
\code{query_layer_attachments()} returns a data.frame.

\code{download_attachments()} returns a list. If an error occurs, the condition is captured and returned in the list.
Otherwise the path to the file that was downloaded is returned.
}
\description{
Get metadata about attachments associated with features in a layer.
Query attachment information using \code{query_layer_attachments()} and
download attachments using \code{download_attachments()}.
}
\examples{
\dontrun{
# create a url path that isn't too wide for CRAN
furl <- paste(
  c(
    "https://services1.arcgis.com/hLJbHVT9ZrDIzK0I",
    "arcgis/rest/services/v8_Wide_Area_Search_Form_Feature_Layer___a2fe9c",
    "FeatureServer/0"
  ),
  collapse = "/"
)
# connect to the layer
layer <- arc_open(furl)

# get the attachment info
att <- query_layer_attachments(layer)

# download them to a path
download_attachments(att, "layer_attachments")
}
}
\references{
\href{https://developers.arcgis.com/rest/services-reference/enterprise/query-attachments-feature-service-layer/}{ArcGIS REST API Documentation}
}
