% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segment.R
\name{hz_dissolve}
\alias{hz_dissolve}
\alias{dissolve_hz}
\title{Dissolving horizon boundaries by grouping variables}
\usage{
hz_dissolve(
  object,
  by,
  idcol = "id",
  depthcols = c("top", "bottom"),
  collapse = FALSE,
  order = FALSE
)

dissolve_hz(
  object,
  by,
  id = "idcol",
  hztop = "top",
  hzbot = "bottom",
  collapse = FALSE,
  order = FALSE
)
}
\arguments{
\item{object}{a \code{data.frame}}

\item{by}{character: column names, to be used as grouping variables, within the object.}

\item{idcol}{character: column name of the pedon ID within the object.}

\item{depthcols}{a character vector of length 2 specifying the names of the horizon depths (e.g. \code{c("top", "bottom")}).}

\item{collapse}{logical: indicating whether to not combine grouping variables before dissolving.}

\item{order}{logical: indicating whether or not to order the object by the id, hztop, and hzbot columns.}

\item{id}{deprecated and replaced with idcol.}

\item{hztop}{deprecated and replaced by depthcols.}

\item{hzbot}{deprecated and replaced by depthcols.}
}
\value{
A \code{data.frame} with the original idcol, by grouping variables, and non-consecutive horizon depths.
}
\description{
This function dissolves or combines horizons that have a common set of grouping variables. It only combines those horizon records that are sequential (e.g. share a horizon boundary). Thus, it can be used to identify discontinuities in the grouping variables along a profile and their unique depths. It is particularly useful for determining the depth to the top or bottom of horizons with a specific category, and should be simpler than previous methods that require aggregating over profiles.
}
\details{
This function assumes the profiles and horizons within the object follow the logic defined by \code{checkHzDepthLogic} (e.g. records are ordered sequentially by id, hztop, and hzbot and without gaps). If the records are not ordered, set the \code{order = TRUE}.
}
\examples{

# example 1
data(jacobs2000)
spc <- jacobs2000

spc$dep_5 <- spc$depletion_pct >=5
spc$genhz <- generalize.hz(spc$name, c("A", "E", "B", "C"), c("A", "E", "B", "C")) 
h <- horizons(spc)

test <- hz_dissolve(h, by = c("genhz", "dep_5"), idcol = "id", depthcols = c("top", "bottom"))

vars <- c("id", "top", "bottom", "genhz", "dep_5")
h[h$id == "92-1", vars]
test[test$id == "92-1", ]


# example 2
df <- data.frame(
    id = 1,
    top    = c(0, 5,  10, 15, 25, 50), 
    bottom = c(5, 10, 15, 25, 50, 100),
    hzname = c("A1",  "A2",  "E/A", "2Bt1", "2Bt2", "2C"),
    genhz  = c("A",   "A",   "E",   "2Bt",  "2Bt", "2C"),
    texcl  = c("sil", "sil", "sil", "sl",   "sl",   "s")
    )

df

hz_dissolve(df, c("genhz", "texcl"))
hz_dissolve(df, c("genhz", "texcl"), collapse = TRUE)

test <- hz_dissolve(df, "genhz")
subset(test, value == "2Bt")

}
\seealso{
\code{\link[=hz_lag]{hz_lag()}}, \code{\link[=hz_intersect]{hz_intersect()}}, \code{\link[=hz_segment]{hz_segment()}} , \code{\link[=checkHzDepthLogic]{checkHzDepthLogic()}}
}
\author{
Stephen Roecker
}
