% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transport_plan.R
\name{as.transport.plan}
\alias{as.transport.plan}
\title{Transform transportation matrix to transportation plan}
\usage{
as.transport.plan(transport_matrix, ...)
}
\arguments{
\item{transport_matrix}{A matrix that is a transportation matrix, i.e. the minimal joint distribution for two samples.}

\item{...}{Unused arguments}
}
\value{
An object of class `transport.plan`. See output of (transport_plan)[transport_plan]
}
\description{
Transform transportation matrix to transportation plan
}
\examples{
set.seed(203987)
n <- 5
d <- 2
x <- matrix(stats::rnorm(d*n), nrow=d, ncol=n)
y <- matrix(stats::rnorm(d*n), nrow=d, ncol=n)
#get hilbert sort orders for x in backwards way
trans_plan <- transport_plan(X=x, Y=x, ground_p = 2, p = 2, 
                         observation.orientation =  "colwise", 
                         method = "hilbert")
trans_matrix <- as.matrix(trans_plan$tplan)
tplan2 <- as.transport.plan(trans_matrix)
all.equal(tplan2, trans_plan$tplan)
}
