% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_weather.R
\name{get_weather}
\alias{get_weather}
\title{Generate a weather dataset for the specified year and airport}
\source{
ASOS download from Iowa Environmental Mesonet,
  \url{https://mesonet.agron.iastate.edu/request/download.phtml}
}
\usage{
get_weather(station, year, dir)
}
\arguments{
\item{station}{A character string---the airport of interest (use the FAA 
LID airport code).}

\item{year}{The year of interest, as an integer (unquoted). Currently, years 
2015 and on are supported.}

\item{dir}{The folder for the dataset to be saved in}
}
\value{
A data frame with ~25,000 rows and 15 variables:
\describe{
\item{origin}{Weather station. Named origin to facilitate merging with
  flights data}
\item{year,month,day,hour}{Time of recording}
\item{temp,dewp}{Temperature and dewpoint in F}
\item{humid}{Relative humidity}
\item{wind_dir,wind_speed,wind_gust}{Wind direction (in degrees), speed
  and gust speed (in mph)}
\item{precip}{Precipitation, in inches}
\item{pressure}{Sea level pressure in millibars}
\item{visib}{Visibility in miles}
\item{time_hour}{Date and hour of the recording as a \code{POSIXct} date}
}
}
\description{
Please note that, even with a strong internet connection, this function 
may take several minutes to download relevant data.
}
\examples{
\donttest{get_weather(station = "PDX", year = 2015, dir = tempdir())}
}
\seealso{
\code{\link{get_flights}} for flight data, 
\code{\link{get_airports}} for airport data, \code{\link{get_airlines}} 
for airline data, and \code{\link{anyflights}} for a wrapper function
}
