% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stack_exchanges.R, R/stack_prod.R, R/tsLegend.R
\name{prodStackExchangesLegend}
\alias{prodStackExchangesLegend}
\alias{prodStackLegend}
\alias{tsLegend}
\title{Plot an interactive legend for time series plots}
\usage{
prodStackExchangesLegend(
  stack = "default",
  legendItemsPerRow = 5,
  legendId = "",
  language = "en"
)

prodStackLegend(
  stack = "eco2mix",
  legendItemsPerRow = 5,
  legendId = "",
  language = "en"
)

tsLegend(labels, colors, types = "line", legendItemsPerRow = 5, legendId = "")
}
\arguments{
\item{stack}{Name of the stack to use. One can visualize available stacks with 
\code{prodStackAliases}}

\item{legendItemsPerRow}{Number of elements to put in each row of the legend.}

\item{legendId}{Id of the legend linked to the graph. This argument is 
usefull when one wants to create a shared legend with 
[prodStackLegend()]}

\item{language}{\code{character} language use for label. Defaut to 'en'. Can be 'fr'.}

\item{labels}{vector containing the names of the times series}

\item{colors}{vector of colors. It must have the same length as parameter
\code{labels}.}

\item{types}{"line" or "area" or a vector with same length as \code{labels}
containing these two values.}
}
\description{
These functions create a nice looking legend that displays values when the user
hovers a time series produced with plot this package. By 
default, the different functions already output a legend. This function
is mostly useful to share a unique legend between two or more time series plots.
}
\details{
Thes functions can be used to create a legend shared by multiple plots 
in a Shiny application or an interactive document created with Rmarkdown.
For instance, let assume one wants to display four productions stacks in a 2x2
layout and have a unique legend below them in a Rmarkdown document. To do so,
one can use the following chunck code:

\preformatted{
```{R, echo = FALSE}
library(manipulateWidget)

combineWidgets(
  prodStack(mydata, areas = "fr", 
            main = "Production stack in France", unit = "GWh", 
            legend = FALSE, legendId = 1, height = "100\%", width = "100\%"),
  prodStack(mydata, areas = "de", 
            main = "Production stack in Germany", unit = "GWh", 
            legend = FALSE, legendId = 1, height = "100\%", width = "100\%"),
  prodStack(mydata, areas = "es", 
            main = "Production stack in Spain", unit = "GWh", 
            legend = FALSE, legendId = 1, height = "100\%", width = "100\%"),
  prodStack(mydata, areas = "be", 
            main = "Production stack in Belgium", unit = "GWh", 
            legend = FALSE, legendId = 1, height = "100\%", width = "100\%"),
  footer = prodStackLegend(legendId = 1)
)
```
}
}
