% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mahalanobis_distance.R
\name{mahalanobis_distance}
\alias{mahalanobis_distance}
\title{Mahalanobis Distance}
\usage{
mahalanobis_distance(data, output = "md", normalize = FALSE)
}
\arguments{
\item{data}{numeric data}

\item{output}{character vector stating the results to be returned. Can be "md"
to return the Mahalanobis distances (default), "bd" to return the absolute breakdown
distances (used to see which columns drive the Mahalanobis distance), or "both"
to return both md and bd values.}

\item{normalize}{logical value of either \code{TRUE} or \code{FALSE}. If \code{TRUE}
will normalize the breakdown distances within each variable so that breakdown distances
across variables can be compared.}
}
\value{
Depending on the \code{output} parameter, the output will return either:
    \enumerate{
      \item \code{md}: vector of Mahalanobis distances, one for each matrix row
      \item \code{bd}: matrix of the absolute values of the breakdown distances; used to see which columns drive the Mahalanobis distance
      \item \code{both}: matrix containing both Mahalanobis and breakdown distances
    }
}
\description{
\code{mahalanobis_distance} calculates the distance between the elements in data
  and the mean vector of the data for outlier detection. Values are independent
  of the scale between variables.
}
\examples{
\dontrun{

x <- data.frame(C1 = rnorm(100), C2 = rnorm(100), C3 = rnorm(100))

# add Mahalanobis distance results to data frame
x \%>\%
  dplyr::mutate(MD = mahalanobis_distance(x))

# add Mahalanobis distance and breakdown distance results to data frame
x \%>\%
  cbind(mahalanobis_distance(x, "both"))

# add Mahalanobis distance and normalized breakdown distance results to data frame
x \%>\%
  cbind(mahalanobis_distance(x, "both", normalize = TRUE))
}

}
\references{
W. Wang and R. Battiti, "Identifying Intrusions in Computer Networks with
Principal Component Analysis," in First International Conference on Availability,
Reliability and Security, 2006.
}
