% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anomaly_series.R
\name{anomaly_series}
\alias{anomaly_series}
\title{A technique for detecting anomalous segments based on CAPA.}
\usage{
anomaly_series(x, penaltywindow = NULL, penaltyanomaly = NULL,
  minimumsegmentlength = 10, warnings = TRUE, method = "meanvar")
}
\arguments{
\item{x}{A numeric vector containing the data which is to be inspected.}

\item{penaltywindow}{A numeric constant indicating the penalty for adding an additional epidemic changepoint. It defaults to a BIC style penalty if no argument is provided.}

\item{penaltyanomaly}{A numeric constant indicating the penalty for adding an additional point anomaly. It defaults to a BIC style penalty if no argument is provided.}

\item{minimumsegmentlength}{An integer indicating the minimum length of epidemic changes. It must be at least 2 and defaults to 10.}

\item{warnings}{A logical determining whether the warnings should be displayed. It defaults to TRUE.}

\item{method}{A string indicating which type of deviations from the baseline are considered. Can be "meanvar" for collective anomalies characterised by joint changes in mean and
variance (the default) and "mean" for collective anomalies characterised by changes in mean only.}
}
\value{
An anomaly_series object.
}
\description{
Method for calling \code{\link{capa.uv}} in a manner consistent with older versions of the anomaly package.
}
\examples{
library(anomaly)
set.seed(2018)
# Generate data typically following a normal distribution with mean 0 and variance 1. 
# Then introduce 3 anomaly windows and 4 point outliers.
x  = rnorm(5000)
x[401:500]   = rnorm(100,4,1)
x[1601:1800] = rnorm(200,0,0.01)
x[3201:3500] = rnorm(300,0,10)
x[c(1000,2000,3000,4000)] = rnorm(4,0,100)
inferred_anomalies = anomaly_series(x)
plot(inferred_anomalies)
summary(inferred_anomalies)
print(inferred_anomalies)

### Repeat with other method

inferred_anomalies = anomaly_series(x,method="mean")
plot(inferred_anomalies)
summary(inferred_anomalies)
print(inferred_anomalies)

### Real data example: 

library(anomaly)
data(Lightcurves)
### Plot the data for Kepler 10965588: No transit apparent
plot(Lightcurves$Kepler10965588$Day,Lightcurves$Kepler10965588$Brightness,xlab = "Day",pch=".")
### Examine a period of 62.9 days for Kepler 10965588
binned_data = period_average(Lightcurves$Kepler10965588,62.9)
inferred_anomalies = anomaly_series(binned_data)
plot(inferred_anomalies,xlab="Bin")
# We found a planet!

}
\references{
\insertRef{2018arXiv180601947F}{anomaly}
}
