% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotation.R
\name{annotation}
\alias{annotation}
\title{Annotation function (single name)}
\usage{
annotation(dat = data.table(), anno.name = "", buildver = "hg19",
  annovar.anno.names = "", database.dir = Sys.getenv("annovarR_DB_DIR", ""),
  db.type = NULL, database.cfg = system.file("extdata",
  "config/databases.toml", package = "annovarR"), func = NULL,
  mysql.connect.params = list(host = "", dbname = "", table.name = "", user =
  "", password = ""), sqlite.connect.params = list(dbname = ""), ...)
}
\arguments{
\item{dat}{A data.table including all of your data, eg. data.table(chr=c(1,2,3), start=c(1111,1112,1113))}

\item{anno.name}{Annotation name, eg. avsnp138, avsnp147, 1000g2015aug_all .etc.}

\item{buildver}{Genome version, hg19, hg38, mm10 and others}

\item{annovar.anno.names}{If anno.name equal perl_annovar_merge, 
you can use annovar.anno.names to annotate multiple database supported by ANNOVAR,
the names can be found on the http://annovar.openbioinformatics.org/en/latest/user-guide/download/}

\item{database.dir}{Dir of the databases}

\item{db.type}{Setting the database type (sqlite or txt)}

\item{database.cfg}{Configuration file of annovarR databases infomation}

\item{func}{Function to anntate the dat data, default is to search the function in extdata/database.toml}

\item{mysql.connect.params}{Connect MySQL database other parameters, 
e.g. list(host='11.11.11.1', port = '3306', user = '', password = '123456')}

\item{sqlite.connect.params}{Connect SqLite database other paramertes, default is not need}

\item{...}{Other parameters see \code{\link{annotation.cols.match}}, \code{\link{annotation.region.match}}, 
\code{\link{annovar}} and \code{\link{vep}}}
}
\description{
Annotation function (single name)
}
\examples{
library(data.table)
chr <- c('chr1', 'chr2', 'chr1')
start <- c('10020', '10020', '10020')
end <- c('10020', '10020', '10020')
ref <- c('A', 'A', 'A')
alt <- c('-', '-', '-')
database <- system.file('extdata', 'demo/hg19_avsnp147.txt', package = 'annovarR')
database.dir <- dirname(database)
dat <- data.table(chr = chr, start = start, end = end, ref = ref, alt = alt)
x <- annotation(dat, 'avsnp147', database.dir = database.dir, 
return.col.names = 'avSNP147', db.type = 'txt')
}
