% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_loom.R
\name{read_loom}
\alias{read_loom}
\title{read_loom}
\usage{
read_loom(
  filename,
  sparse = TRUE,
  cleanup = FALSE,
  X_name = "spliced",
  obs_names = "CellID",
  obsm_names = NULL,
  var_names = "Gene",
  varm_names = NULL,
  dtype = "float32",
  ...
)
}
\arguments{
\item{filename}{The filename.}

\item{sparse}{Whether to read the data matrix as sparse.}

\item{cleanup}{Whether to collapse all obs/var fields that only store one unique value into \code{.uns['loom-.']}.}

\item{X_name}{Loompy key with which the data matrix \code{AnnData.X} is initialized.}

\item{obs_names}{Loompy key where the observation/cell names are stored.}

\item{obsm_names}{Loompy keys which will be constructed into observation matrices}

\item{var_names}{Loompy key where the variable/gene names are stored.}

\item{varm_names}{Loompy keys which will be constructed into variable matrices}

\item{dtype}{Numpy data type.}

\item{...}{Arguments to loompy.connect}
}
\description{
Read \code{.loom}-formatted hdf5 file.
}
\details{
This reads the whole file into memory. Beware that you have to explicitly state when you want to read the file as
sparse data.
}
\examples{
\dontrun{
ad <- read_loom("dataset.loom")
}
}
