% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictSpecies.R
\name{predictSpecies}
\alias{predictSpecies}
\title{Classifies Crops Using Specified Models}
\usage{
predictSpecies(
  input,
  model,
  resize = 456,
  standardize = FALSE,
  batch = 1,
  workers = 1
)
}
\arguments{
\item{input}{either dataframe with MD crops or list of filenames}

\item{model}{models with which to classify species}

\item{resize}{resize images before classification, defaults to 299x299px}

\item{standardize}{standardize images, defaults to FALSE}

\item{batch}{number of images processed in each batch (keep small)}

\item{workers}{number of cores}
}
\value{
a matrix of likelihoods for each class for each image
}
\description{
Classifies Crops Using Specified Models
}
\examples{
\dontrun{
pred <- classifySpecies(imagesallanimal, paste0(modelfile, ".h5"),
                      resize = 456, standardize = FALSE, batch_size = 64, workers = 8)
}
}
