% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-density.r, R/stat-density.r
\name{geom_density}
\alias{geom_density}
\alias{stat_density}
\title{Display a smooth density estimate.}
\usage{
geom_density(mapping = NULL, data = NULL, stat = "density",
  position = "identity", ..., na.rm = FALSE, show.legend = NA,
  inherit.aes = TRUE)

stat_density(mapping = NULL, data = NULL, geom = "area",
  position = "stack", ..., bw = "nrd0", adjust = 1,
  kernel = "gaussian", trim = FALSE, na.rm = FALSE,
  show.legend = NA, inherit.aes = TRUE)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link{aes}} or
\code{\link{aes_}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
   options:

   If \code{NULL}, the default, the data is inherited from the plot
   data as specified in the call to \code{\link{ggplot}}.

   A \code{data.frame}, or other object, will override the plot
   data. All objects will be fortified to produce a data frame. See
   \code{\link{fortify}} for which variables will be created.

   A \code{function} will be called with a single argument,
   the plot data. The return value must be a \code{data.frame.}, and
   will be used as the layer data.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{...}{other arguments passed on to \code{\link{layer}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{color = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{na.rm}{If \code{FALSE} (the default), removes missing values with
a warning.  If \code{TRUE} silently removes missing values.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link{borders}}.}

\item{geom, stat}{Use to override the default connection between
\code{geom_density} and \code{stat_density}.}

\item{bw}{the smoothing bandwidth to be used, see
\code{\link{density}} for details}

\item{adjust}{adjustment of the bandwidth, see
\code{\link{density}} for details}

\item{kernel}{kernel used for density estimation, see
\code{\link{density}} for details}

\item{trim}{This parameter only matters if you are displaying multiple
densities in one plot. If \code{FALSE}, the default, each density is
computed on the full range of the data. If \code{TRUE}, each density
is computed over the range of that group: this typically means the
estimated x values will not line-up, and hence you won't be able to
stack density values.}
}
\description{
A kernel density estimate, useful for display the distribution of variables
with underlying smoothness.
}
\section{Aesthetics}{

\Sexpr[results=rd,stage=build]{animint2:::rd_aesthetics("geom", "density")}
}

\section{Computed variables}{

\describe{
  \item{density}{density estimate}
  \item{count}{density * number of points - useful for stacked density
     plots}
  \item{scaled}{density estimate, scaled to maximum of 1}
}
}

\examples{
ggplot(diamonds, aes(carat)) +
  geom_density()

ggplot(diamonds, aes(carat)) +
  geom_density(adjust = 1/5)
ggplot(diamonds, aes(carat)) +
  geom_density(adjust = 5)

ggplot(diamonds, aes(depth, colour = cut)) +
  geom_density() +
  xlim(55, 70)
ggplot(diamonds, aes(depth, fill = cut, colour = cut)) +
  geom_density(alpha = 0.1) +
  xlim(55, 70)

\donttest{
# Stacked density plots: if you want to create a stacked density plot, you
# probably want to 'count' (density * n) variable instead of the default
# density

# Loses marginal densities
ggplot(diamonds, aes(carat, fill = cut)) +
  geom_density(position = "stack")
# Preserves marginal densities
ggplot(diamonds, aes(carat, ..count.., fill = cut)) +
  geom_density(position = "stack")

# You can use position="fill" to produce a conditional density estimate
ggplot(diamonds, aes(carat, ..count.., fill = cut)) +
  geom_density(position = "fill")
}
}
\seealso{
See \code{\link{geom_histogram}}, \code{\link{geom_freqpoly}} for
  other methods of displaying continuous distribution.
  See \code{\link{geom_violin}} for a compact density display.
}
