% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amber.studies.R
\name{amber.study}
\alias{amber.study}
\title{Get a study}
\usage{
amber.study(amber, id)
}
\arguments{
\item{amber}{An Amber object}

\item{id}{Study's name or identifier}
}
\value{
A study object as a named list
}
\description{
Get a study by name or identifier.
}
\examples{
\dontrun{
a <- amber.login("https://amber-demo.obiba.org")
amber.study(a, id = "Trauma Registry")
amber.study(a, id = "6151b5234268f582926d37f44")
amber.logout(a)
}
}
\seealso{
Other studies functions: 
\code{\link{amber.campaigns}()},
\code{\link{amber.campaign}()},
\code{\link{amber.case_report_export}()},
\code{\link{amber.case_report_forms}()},
\code{\link{amber.case_report_form}()},
\code{\link{amber.case_reports}()},
\code{\link{amber.form_revisions}()},
\code{\link{amber.form_revision}()},
\code{\link{amber.forms}()},
\code{\link{amber.form}()},
\code{\link{amber.interview_designs}()},
\code{\link{amber.interview_design}()},
\code{\link{amber.interview_export}()},
\code{\link{amber.interviews}()},
\code{\link{amber.participants}()},
\code{\link{amber.participant}()},
\code{\link{amber.studies}()}
}
\concept{studies functions}
