% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amapro.R
\name{am.cmd}
\alias{am.cmd}
\title{Run a command}
\usage{
am.cmd(id, cmd = NULL, target = NULL, ...)
}
\arguments{
\item{id}{A map widget from \link{am.init} or a proxy from \link{am.proxy}}

\item{cmd}{A command name string, like 'setFitView'}

\item{target}{A target's name string, or 'map' for the map itself.}

\item{...}{command attributes \cr}
}
\value{
A map or a map proxy
}
\description{
Execute a command on a target element
}
\details{
\emph{am.cmd} provides interaction with the map.\cr
Commands are sent to the map itself, or to objects inside or outside it.\cr
AMap built-in objects have predefined set of commands listed in the API.
Commands can modify an object (setZoom), but also get data from it (getCenter).\cr
\emph{amapro} introduces its own commands like \emph{set}, \emph{addTo} or \emph{code}, described in the \link{Introduction}.
}
\examples{
if (interactive()) {
  am.init() |> 
  am.cmd('set', 'InfoWindow', position=c(116.6, 40), content='Beijing')
}
}
\seealso{
\link{am.init} code example and \link{Introduction}
}
