% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\name{process_hms}
\alias{process_hms}
\title{Process wildfire smoke data}
\usage{
process_hms(date = "2018-01-01", path = NULL, extent = NULL, ...)
}
\arguments{
\item{date}{character(1 or 2). Date (1) or start and end dates (2).
Format YYYY-MM-DD (ex. September 1, 2023 = "2023-09-01").}

\item{path}{character(1). Directory with downloaded NOAA HMS data files.}

\item{extent}{numeric(4) or SpatExtent giving the extent of the output
if \code{NULL} (default), the entire data is returned}

\item{...}{Placeholders.}
}
\value{
a \code{SpatVector} or character object
}
\description{
The \code{process_hms()} function imports and cleans raw wildfire smoke
plume coverage data, returning a single \code{SpatVector} object.
}
\note{
\code{process_hms()} will return a character object if there are no wildfire
smoke plumes present for the selected dates and density. The returned
character will contain the density value and the sequence of dates
for which no wildfire smoke plumes were detected (see "Examples").
If multiple density polygons overlap, the function will return the
highest density value.
}
\examples{
hms <- process_hms(
  date = c("2018-12-30", "2019-01-01"),
  path = "../tests/testdata/hms/"
)
}
\author{
Mitchell Manware
}
