% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/av_api_key.R
\name{av_api_key}
\alias{av_api_key}
\title{Set the Alpha Vantage API Key}
\usage{
av_api_key(api_key)
}
\arguments{
\item{api_key}{A character string with your Alpha Vantage API Key.}
}
\value{
Invisibly returns API key once set. Use print method to view.
}
\description{
Set the Alpha Vantage API Key
}
\details{
The Alpha Vantage API key must be set prior to using \code{\link[=av_get]{av_get()}}. You can obtain
an API key at the \href{https://www.alphavantage.co/}{Alpha Vantage Website}.
}
\examples{
\dontrun{
av_api_key("YOUR_API_KEY")
av_get(symbol = "MSFT", av_fun = "TIME_SERIES_INTRADAY", interval = "15min", outputsize = "full")
}

}
\seealso{
\code{\link[=av_get]{av_get()}}
}
