% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Topology.R
\name{testMRCA}
\alias{testMRCA}
\title{Tests for MRCA annotation enrichment in lineage trees}
\usage{
testMRCA(graphs, field, root = "Germline", exclude = c("Germline", NA),
  nperm = 200, progress = FALSE)
}
\arguments{
\item{graphs}{list of igraph object containing annotated lineage trees.}

\item{field}{string defining the annotation field to test.}

\item{root}{name of the root (germline) node.}

\item{exclude}{vector of strings defining \code{field} values to exclude from the
set of potential founder annotations.}

\item{nperm}{number of permutations to perform.}

\item{progress}{if \code{TRUE} show a progress bar.}
}
\value{
An \link{MRCATest} object containing the test results and permutation
          realizations.
}
\description{
\code{testMRCA} performs a permutation test on a set of lineage trees to determine
the significance of an annotation's association with the MRCA position of the lineage
trees.
}
\examples{
\donttest{
# Define example tree set
graphs <- ExampleTrees[1-10]

# Perform MRCA test on isotypes
x <- testMRCA(graphs, "ISOTYPE", nperm=10)
print(x)
}

}
\seealso{
Uses \link{getMRCA} and \link{getPathLengths}. 
          See \link{plotMRCATest} for plotting the permutation distributions.
}
