% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Topology.R
\name{getPathLengths}
\alias{getPathLengths}
\title{Calculate path lengths from the tree root}
\usage{
getPathLengths(graph, root = "Germline", field = NULL, exclude = NULL)
}
\arguments{
\item{graph}{igraph object containing an annotated lineage tree.}

\item{root}{name of the root (germline) node.}

\item{field}{annotation field to use for exclusion of nodes from step count.}

\item{exclude}{annotation values specifying which nodes to exclude from step count. 
If \code{NULL} consider all nodes. This does not affect the weighted
(distance) path length calculation.}
}
\value{
A data.frame with columns:
          \itemize{
            \item  \code{NAME}:      node name
            \item  \code{STEPS}:     path length as the number of nodes traversed
            \item  \code{DISTANCE}:  path length as the sum of edge weights
          }
}
\description{
\code{getPathLengths} calculates the unweighted (number of steps) and weighted (distance) 
path lengths from the root of a lineage tree.
}
\examples{
# Define example graph
graph <- ExampleTrees[[24]]

# Consider all nodes
getPathLengths(graph, root="Germline")

# Exclude nodes without an isotype annotation from step count
getPathLengths(graph, root="Germline", field="ISOTYPE", exclude=NA)

}
\seealso{
See \link{buildPhylipLineage} for generating input trees.
}
