% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keyword_vis.R
\name{keyword_vis}
\alias{keyword_vis}
\title{Visualization of grouped keyword co-occurrence network}
\usage{
keyword_vis(tibble_graph, facet = TRUE, max_nodes = 10)
}
\arguments{
\item{tibble_graph}{A \code{tbl_graph} output by \code{\link[akc]{keyword_group}}.}

\item{facet}{Whether the figure should use facet or not.}

\item{max_nodes}{The maximum number of nodes displayed in each group.}
}
\value{
An object yielded by \code{\link[ggraph]{ggraph}}
}
\description{
Visualization of network-based keyword clustering, with frequency and co-occurrence information attached.
}
\details{
When \code{facet == TRUE},the function returns a faceted figure with limited number of nodes
(adjuseted by \code{max_nodes} parameter).When \code{facet == FALSE},all the nodes would be displayed in one
network.Colors are used to specify the groups, the size of nodes is proportional to the keyword frequency,
while the alpha of edges is proportional to the co-occurrence relationship between keywords.
}
\examples{

library(akc)
\donttest{
bibli_data_table \%>\%
  keyword_clean(id = "id",keyword = "keyword") \%>\%
  keyword_group(id = "id",keyword = "keyword") \%>\%
  keyword_vis()

# without facet
bibli_data_table \%>\%
  keyword_clean(id = "id",keyword = "keyword") \%>\%
  keyword_group(id = "id",keyword = "keyword") \%>\%
  keyword_vis(facet = FALSE)

# remove legends
bibli_data_table \%>\%
  keyword_clean(id = "id",keyword = "keyword") \%>\%
  keyword_group(id = "id",keyword = "keyword") \%>\%
  keyword_vis() + ggplot2::guides(fill = FALSE)
}
}
\seealso{
\code{\link[ggraph]{ggraph}}
}
