% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.GRiwrm.R
\name{plot.GRiwrm}
\alias{plot.GRiwrm}
\title{Display of a diagram representing the network structure of a GRiwrm object}
\usage{
\method{plot}{GRiwrm}(
  x,
  display = TRUE,
  orientation = "LR",
  width = "100\%",
  height = "100\%",
  ...
)
}
\arguments{
\item{x}{[GRiwrm object] data to display. See \link{CreateGRiwrm} for details}

\item{display}{\link{logical} if \code{TRUE} displays the diagram with \link[DiagrammeR:mermaid]{DiagrammeR::mermaid}, returns the mermaid code otherwise}

\item{orientation}{\link{character} orientation of the graph. Possible values are "LR" (left-right), "RL" (right-left), "TB" (top-bottom), or "BT" (bottom-top). "LR" by default}

\item{width}{\link{numeric} width of the resulting graphic in pixels (See \link[DiagrammeR:mermaid]{DiagrammeR::mermaid})}

\item{height}{\link{numeric} height of the resulting graphic in pixels (See \link[DiagrammeR:mermaid]{DiagrammeR::mermaid})}

\item{...}{Other arguments and parameters you would like to send to JavaScript (See \link[DiagrammeR:mermaid]{DiagrammeR::mermaid})}
}
\value{
Mermaid code of the diagram if display is \code{FALSE}, otherwise the function returns the diagram itself.
}
\description{
Display of a diagram representing the network structure of a GRiwrm object
}
\details{
This function only works inside RStudio because the HTMLwidget produced by DiagrammeR
is not handled on some platforms
}
\examples{
\dontrun{
# Display diagram
plot.GRiwrm(griwrm)
# Is the same as
DiagrammeR::mermaid(plot.GRiwrm(griwrm, display = FALSE), width = "100\%", height = "100\%")
}

}
