% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aion-package.R
\docType{package}
\name{aion-package}
\alias{aion-package}
\alias{aion}
\title{aion: Archaeological Time Series}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

A toolkit for archaeological time series and time intervals. This package provides a system of classes and methods to represent and work with archaeological time series and time intervals. Dates are represented as "rata die" and can be converted to (virtually) any calendar defined by Reingold and Dershowitz (2018) \doi{10.1017/9781107415058}. This packages offers a simple API that can be used by other specialized packages.
}
\details{
\tabular{ll}{
\strong{Package:} \tab aion \cr
\strong{Type:} \tab Package \cr
\strong{Version:} \tab 1.1.0 \cr
\strong{License:} \tab GPL-3 \cr
\strong{Zenodo:} \tab \doi{10.5281/zenodo.8032278} \cr
}
}
\section{Package options}{

\code{aion} uses the following \code{\link[=options]{options()}} to configure behaviour:
\itemize{
\item \code{aion.precision}: an \code{\link{integer}} indicating the number of decimal
places (defaults to \code{NA}).
\item \code{aion.calendar}: a \code{\linkS4class{TimeScale}} object (default calendar for
printing).
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://packages.tesselle.org/aion/}
  \item \url{https://github.com/tesselle/aion}
  \item Report bugs at \url{https://github.com/tesselle/aion/issues}
}

}
\author{
\strong{Full list of authors and contributors} (alphabetic order):

\tabular{ll}{
Nicolas Frerebeau \tab \emph{Université Bordeaux Montaigne, France} \cr
Brice Lebrun \tab \emph{Université Bordeaux Montaigne, France} \cr
Joe Roe \tab \emph{Universität Bern, Switzerland} \cr
}

\strong{Package maintainer}

Nicolas Frerebeau\cr
\email{nicolas.frerebeau@u-bordeaux-montaigne.fr}

Archéosciences Bordeaux (UMR 6034)\cr
Maison de l'Archéologie\cr
Université Bordeaux Montaigne\cr
F-33607 Pessac cedex\cr
France
}
\keyword{internal}
