% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_alignment.R
\name{read_alignment}
\alias{read_alignment}
\title{Read a protein sequence multiple alignment}
\usage{
read_alignment(
  gene = c("ATM", "BRCA1", "BRCA2", "CHEK2", "MRE11", "MSH6", "NBN", "PALB2", "PMS2",
    "RAD50", "RAD51", "XRCC2"),
  file = NULL
)
}
\arguments{
\item{gene}{The gene name for which an alignment is provided with this
package. Use the function \code{\link[=alignment_file]{alignment_file()}} to list the pre-bundled
alignments.}

\item{file}{The path to a Multi-FASTA file. If this argument is given, it
takes precedence over the \code{gene} parameter.}
}
\value{
An alignment object; essentially, a character matrix, whose elements
are protein residues in one-letter notation. Rows are sequences and columns
are alignment positions.
}
\description{
Reads a protein sequence multiple alignment (PSMA) from either a set of
pre-bundled alignments, by gene name, or from a Multi-FASTA file.
}
\examples{
# Read in the alignment for the gene XRCC2
read_alignment('XRCC2')

}
