% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/warmMonth.R
\name{warmMonth}
\alias{warmMonth}
\title{Warmest month of the year}
\usage{
warmMonth(mx, dates, type = "temp", ...)
}
\arguments{
\item{mx}{vector of daily maximum temperature series.}

\item{dates}{vector of dates corresponding with daily temperature series}

\item{type}{type of output. It can be "temp" for temperature or "month" for the number of the warmest month.}

\item{...}{any other argument. It is expected to be "na.rm" in case NA values are required to be removed.}
}
\value{
Depending on argument type, the output will be a numeric value with the month (type = "month") or with temperature (type = "temp").
}
\description{
Calculates the mean temperature of the warmest month of the year
}
\examples{


warmMonth(mx = daily_tmax,
           dates = seq.Date(as.Date('1981-01-01'),
            as.Date('2010-12-31'), by ='day'),
           type = 'temp',
           na.rm = TRUE)

}
