% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitSingle.R
\name{single_trial_analysis}
\alias{single_trial_analysis}
\title{Single Trial Analysis}
\usage{
single_trial_analysis(
  results = NULL,
  progress = TRUE,
  engine = "asreml",
  remove_outliers = TRUE
)
}
\arguments{
\item{results}{Object of class \code{checkAgri} resulting of executing
\code{check_design_met()} function.}

\item{progress}{Should the progress of the modeling be printed.
If \code{TRUE}, for every trial a line is output indicating the traits fitted
for the particular trial.}

\item{engine}{A character string specifying the name of the mixed modeling
engine to use, either \code{lme4} or \code{asreml}. For spatial designs,
\code{SpATS} is always used, for other designs \code{asreml} as a default.}

\item{remove_outliers}{Should outliers be removed? \code{TRUE} by default.}
}
\value{
An object of class \code{smaAgri}, with a list of:
\item{fitted_models}{A list containing the fitted models. (Both models, the
one with Genotype as Random and the one with Genotype as Fixed)}
\item{resum_fitted_model}{A data.frame containing a summary of the fitted
models.}
\item{outliers}{A data.frame containing extreme observations. If
\code{remove_outliers} is \code{TRUE}, this data.frame will contain the
observations removed.}
\item{blues_blups}{A data.frame containing BLUPs/BLUEs for all the genotypes
in each trial.}
\item{std_residuals}{A data.frame containing the standardized residuals for
the model with genotype as random component.}
\item{data}{A data.frame containing the data used. If \code{remove_outliers}
is \code{TRUE}, data will have missing values for the outliers detected.}
}
\description{
The results of the \code{check_design_met()} function are used in
\code{single_trial_analysis()} to fit single trial models. This function can
fit, Completely Randomized Designs (CRD), Randomized Complete Block Designs
(RCBD), Resolvable Incomplete Block Designs (res-IBD), Non-Resolvable
Row-Column Designs (Row-Col) and Resolvable Row-Column Designs (res-Row-Col).

Returns an object of class \code{smaAgri}, with a list of trial summary,
BLUEs, BLUPs, heritability, variance components, potential extreme
observations, residuals,
the models fitted and the data used.
This function will generate the required output to be used in the two-stage
analysis.
}
\examples{
\donttest{
library(agridat)
library(agriutilities)
data(besag.met)
dat <- besag.met
results <- check_design_met(
  data = dat,
  genotype = "gen",
  trial = "county",
  traits = c("yield"),
  rep = "rep",
  block = "block",
  col = "col",
  row = "row"
)
out <- single_trial_analysis(results, progress = FALSE)
print(out)
}
}
