% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coord.r
\name{Coord3D}
\alias{Coord3D}
\title{3D coordinate vector R6 Class}
\description{
\code{Coord3D} is an \code{\link[R6:R6Class]{R6::R6Class()}} object representing three-dimensional points
represented by Cartesian Coordinates.
}
\examples{
p <- as_coord3d(x = rnorm(100, 2), y = rnorm(100, 2), z = rnorm(100, 2))
print(p, n = 10)
pc <- mean(p) # Centroid
# method chained affine transformation matrices are auto-pre-multiplied
p$
  translate(-pc)$
  reflect("xy-plane")$
  rotate("z-axis", degrees(90))$
  print(n = 10)
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{xyzw}}{A four-column matrix representing the homogeneous coordinates.
The first three columns are "x", "y", and "z" coordinates
and the fourth column is all ones.}

\item{\code{x}}{A numeric vector of x-coordinates.}

\item{\code{y}}{A numeric vector of y-coordinates.}

\item{\code{z}}{A numeric vector of z-coordinates.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Coord3D-new}{\code{Coord3D$new()}}
\item \href{#method-Coord3D-permute}{\code{Coord3D$permute()}}
\item \href{#method-Coord3D-print}{\code{Coord3D$print()}}
\item \href{#method-Coord3D-project}{\code{Coord3D$project()}}
\item \href{#method-Coord3D-reflect}{\code{Coord3D$reflect()}}
\item \href{#method-Coord3D-rotate}{\code{Coord3D$rotate()}}
\item \href{#method-Coord3D-scale}{\code{Coord3D$scale()}}
\item \href{#method-Coord3D-shear}{\code{Coord3D$shear()}}
\item \href{#method-Coord3D-translate}{\code{Coord3D$translate()}}
\item \href{#method-Coord3D-transform}{\code{Coord3D$transform()}}
\item \href{#method-Coord3D-clone}{\code{Coord3D$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Coord3D-new"></a>}}
\if{latex}{\out{\hypertarget{method-Coord3D-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Coord3D$new(xyzw)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xyzw}}{A matrix with four columns representing (homogeneous) coordinates.
The first three columns represent x, y, and z coordinates and
the last column is all ones.
Column names should be "x", "y", "z", and "w".}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Coord3D-permute"></a>}}
\if{latex}{\out{\hypertarget{method-Coord3D-permute}{}}}
\subsection{Method \code{permute()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Coord3D$permute(permutation = c("xyz", "xzy", "yxz", "yzx", "zyx", "zxy"))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{permutation}}{Either "xyz" (no permutation), "xzy" (permute y and z axes),
"yxz" (permute x and y axes), "yzx" (x becomes z, y becomes x, z becomes y),
"zxy" (x becomes y, y becomes z, z becomes x), "zyx" (permute x and z axes)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Coord3D-print"></a>}}
\if{latex}{\out{\hypertarget{method-Coord3D-print}{}}}
\subsection{Method \code{print()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Coord3D$print(n = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{Number of coordinates to print.  If \code{NULL} print all of them.}

\item{\code{...}}{Passed to \code{\link[=format.default]{format.default()}}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Coord3D-project"></a>}}
\if{latex}{\out{\hypertarget{method-Coord3D-project}{}}}
\subsection{Method \code{project()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Coord3D$project(
  plane = as_plane3d("xy-plane"),
  ...,
  scale = 0,
  alpha = angle(45, "degrees")
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{plane}}{A \link{Plane3D} object of length one representing the plane
you wish to reflect across or project to or an object coercible to one using \code{as_plane3d(plane, ...)}
such as "xy-plane", "xz-plane", or "yz-plane".}

\item{\code{...}}{Passed to \code{\link[=project3d]{project3d()}}.}

\item{\code{scale}}{Oblique projection foreshortening scale factor.
A (degenerate) \code{0} value indicates an orthographic projection.
A value of \code{0.5} is used by a \dQuote{cabinet projection}
while a value of \code{1.0} is used by a \dQuote{cavalier projection}.}

\item{\code{alpha}}{Oblique projection angle (the angle the third axis is projected going off at).
An \code{\link[=angle]{angle()}} object or one coercible to one with \code{as_angle(alpha, ...)}.
Popular angles are 45 degrees, 60 degrees, and \code{arctangent(2)} degrees.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Coord3D-reflect"></a>}}
\if{latex}{\out{\hypertarget{method-Coord3D-reflect}{}}}
\subsection{Method \code{reflect()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Coord3D$reflect(plane = as_plane3d("xy-plane"), ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{plane}}{A \link{Plane3D} object of length one representing the plane
you wish to reflect across or project to or an object coercible to one using \code{as_plane3d(plane, ...)}
such as "xy-plane", "xz-plane", or "yz-plane".}

\item{\code{...}}{Passed to \code{\link[=reflect3d]{reflect3d()}}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Coord3D-rotate"></a>}}
\if{latex}{\out{\hypertarget{method-Coord3D-rotate}{}}}
\subsection{Method \code{rotate()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Coord3D$rotate(axis = as_coord3d("z-axis"), theta = angle(0), ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{axis}}{A \link{Coord3D} class object or one that can coerced to one by \code{as_coord3d(axis, ...)}.
The \code{axis} represents the axis to be rotated around.}

\item{\code{theta}}{An \code{\link[=angle]{angle()}} object of length one or an object coercible to one by \code{as_angle(theta, ...)}.}

\item{\code{...}}{Passed to \code{\link[=rotate3d]{rotate3d()}}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Coord3D-scale"></a>}}
\if{latex}{\out{\hypertarget{method-Coord3D-scale}{}}}
\subsection{Method \code{scale()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Coord3D$scale(x_scale = 1, y_scale = x_scale, z_scale = x_scale)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x_scale}}{Scaling factor to apply to x coordinates}

\item{\code{y_scale}}{Scaling factor to apply to y coordinates}

\item{\code{z_scale}}{Scaling factor to apply to z coordinates}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Coord3D-shear"></a>}}
\if{latex}{\out{\hypertarget{method-Coord3D-shear}{}}}
\subsection{Method \code{shear()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Coord3D$shear(
  xy_shear = 0,
  xz_shear = 0,
  yx_shear = 0,
  yz_shear = 0,
  zx_shear = 0,
  zy_shear = 0
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xy_shear}}{Shear factor: \code{x = x + xy_shear * y + xz_shear * z}}

\item{\code{xz_shear}}{Shear factor: \code{x = x + xy_shear * y + xz_shear * z}}

\item{\code{yx_shear}}{Shear factor: \code{y = yx_shear * x + y + yz_shear * z}}

\item{\code{yz_shear}}{Shear factor: \code{y = yx_shear * x + y + yz_shear * z}}

\item{\code{zx_shear}}{Shear factor: \code{z = zx_shear * x + zy_shear * y + z}}

\item{\code{zy_shear}}{Shear factor: \code{z = zx_shear * x + zy_shear * y + z}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Coord3D-translate"></a>}}
\if{latex}{\out{\hypertarget{method-Coord3D-translate}{}}}
\subsection{Method \code{translate()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Coord3D$translate(x = as_coord3d(0, 0, 0), ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{A \link{Coord3D} object of length one or an object coercible to one by \code{as_coord3d(x, ...)}.}

\item{\code{...}}{Passed to \code{as_coord3d(x, ...)} if \code{x} is not a \link{Coord3D} object}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Coord3D-transform"></a>}}
\if{latex}{\out{\hypertarget{method-Coord3D-transform}{}}}
\subsection{Method \code{transform()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Coord3D$transform(mat = transform3d())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{mat}}{A 4x4 matrix representing a post-multiplied affine transformation matrix.
The last \strong{column} must be equal to \code{c(0, 0, 0, 1)}.
If the last \strong{row} is \code{c(0, 0, 0, 1)} you may need to transpose it
to convert it from a pre-multiplied affine transformation matrix to a post-multiplied one.
If a 3x3 matrix (such as a 3x3 post-multiplied 3D rotation matrix)
we'll quietly add a final column/row equal to \code{c(0, 0, 0, 1)}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Coord3D-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Coord3D-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Coord3D$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
